<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Form\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\ListField;
use Joomla\Plugin\System\Joomlab\Helper\LanguageHelper;
use Joomla\Plugin\System\Joomlab\Helper\UtilityHelper;

class CountryCodeListField extends ListField
{
    protected $type = 'CountryCodeList';

    protected function getOptions()
    {
        $options = [];

        foreach (UtilityHelper::getCountriesList() as $country) {
            $options[] = (object) [
                'value' => $country['code'],
                'text'  => LanguageHelper::langCodeToFlag($country['code']) . ' ' . $country['name'],
            ];
        }

        return array_merge(parent::getOptions(), $options);
    }
}