<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Router\Route;

class BackupProfileController extends FormController
{
    protected $view_item = 'backupProfile';

    protected $view_list = 'backupProfiles';

    public function getModel($name = 'BackupProfile', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function setDefault()
    {
        $pk = (int) ($this->input->get('cid', [], 'ARRAY')[0] ?? 0);

        if ($this->getModel()->setDefault($pk)) {
            $this->setMessage(Text::_('COM_JLADMIN_BACKUP_PROFILE_IS_DEFAULTED_MSG'));
        }

        $this->setRedirect(Route::_('index.php?option=com_jladmin&view=backupProfiles', false));
    }
}
