<?php

/**
 * @package     Joomlab
 * @subpackage  com_admin
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Component\Router\RouterServiceInterface;
use Joomla\CMS\Component\Router\RouterServiceTrait;
use Joomla\CMS\Extension\BootableExtensionInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLRegistryAwareTrait;
use Joomla\Event\Event;
use Psr\Container\ContainerInterface;

final class JLAdminComponent extends MVCComponent implements
    BootableExtensionInterface,
    RouterServiceInterface
{
    use RouterServiceTrait;
    use HTMLRegistryAwareTrait;

    public const MAJOR_VERSION = 1;

    public const MINOR_VERSION = 0;

    public const PATCH_VERSION = 3;

    public const FULL_VERSION = '1.0.5';

    public const HASH_VERSION = 'f63163cdb1493c95a036f8830d0132c5';

    public static function renderBottomLink(): string
    {
        return ComponentHelper::getParams('com_jladmin')->get('removeBottomLink')
            ? ''
            : '<p style="text-align: center; font-size: 14px; color: #555">'
            . '   <a href="https://joomlab.net/joomlab-admin" target="_blank">JL Admin</a><sup>v' . JLAdminComponent::FULL_VERSION . '</sup> is Free Software released under the GNU General Public License.<br>'
            . '   If you enjoyed your experience with our product, please take a moment to leave a <a href="https://extensions.joomla.org/extension/access-a-security/jl-admin" target="_blank">review on JED</a>'
            . '</p>';
    }

    public function boot(ContainerInterface $container)
    {
        if (JLADMIN_PRO) {
            Factory::getApplication()
                ->getDispatcher()
                ->dispatch('onJLAdminBootComponent', new Event('onJLAdminBootComponent'));
        }
    }
}
