<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\ListModel;
use Joomla\Database\ParameterType;

class BackupsModel extends ListModel
{
    public function __construct($config = [])
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = [
                'id',
                'a.id',
                'profileId',
                'a.profileId',
                'clientId',
                'a.clientId',
                'profileTitle',
                'backupFile',
                'a.backupFile',
                'createdBy',
                'a.createdBy',
                'createdDate',
                'a.createdDate',
            ];
        }

        parent::__construct($config);
    }

    protected function populateState($ordering = 'a.id', $direction = 'asc')
    {
        parent::populateState($ordering, $direction);
    }

    protected function getStoreId($id = '')
    {
        // Compile the store id.
        $id .= ':' . $this->getState('filter.search');
        $id .= ':' . $this->getState('filter.profileId');
        $id .= ':' . $this->getState('filter.clientId');

        return parent::getStoreId($id);
    }

    protected function getListQuery()
    {
        $db    = $this->getDatabase();
        $query = $db->getQuery(true);
        $query->select(
            $this->getState(
                'list.select',
                'a.id, a.profileId, a.clientId, a.backupFile, a.createdBy, a.createdDate'
            )
        )
            ->select('u1.name AS authorName, a2.title AS profileTitle, a2.params AS profileParams')
            ->from($db->quoteName('#__joomlab_backups', 'a'))
            ->join('INNER', $db->quoteName('#__joomlab_backup_profiles', 'a2'), 'a2.id = a.profileId')
            ->join('LEFT', $db->quoteName('#__users', 'u1'), 'u1.id = a.createdBy');

        if (is_numeric($profileId = $this->getState('filter.profileId'))) {
            $query->where('a.profileId = ' . (int) $profileId);
        }

        if (is_numeric($clientId = $this->getState('filter.clientId'))) {
            $query->where('a.clientId = ' . (int) $clientId);
        }

        // Filter by search in title.
        $search = $this->getState('filter.search');

        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $search = (int)substr($search, 3);
                $query->where($db->quoteName('a.id') . ' = :search')
                    ->bind(':search', $search, ParameterType::INTEGER);
            } elseif (stripos($search, 'author:') === 0) {
                $search = '%' . substr($search, 7) . '%';
                $query->where($db->quoteName('u1.name') . ' LIKE :search')
                    ->bind(':search', $search);
            } else {
                $search = '%' . trim($search) . '%';
                $query->where('(a.backupFile LIKE :search OR a2.title LIKE :search)')
                    ->bind(':search', $search);
            }
        }

        // Add the list ordering clause.
        $orderCol  = $this->state->get('list.ordering', 'a.id');
        $orderDirn = $this->state->get('list.direction', 'desc');
        $query->order($db->escape($orderCol) . ' ' . $db->escape($orderDirn));

        return $query;
    }
}
