<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\View\Redirects;

defined('_JEXEC') or die;

use Joomla\Plugin\System\Joomlab\MVC\View\ListView;

class HtmlView extends ListView
{
    public function __construct($config = [])
    {
        if (JLADMIN_PRO) {
            $config['template_path'] = JPATH_PLUGINS . '/jladmin/pro/app/tmpl/redirects';
        }

        parent::__construct($config);
    }

    public function display($tpl = null): void
    {
        if (JLADMIN_PRO) {
            parent::display($tpl);
        } else {
            echo $this->loadTemplate();
        }
    }
}