<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\JLAdmin\Administrator\Extension\JLAdminComponent;

$app       = Factory::getApplication();
$user      = $this->getCurrentUser();
$userId    = $user->id;
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));

HTMLHelper::_('joomlab.framework');
?>

<form
        class="jl-scope"
        action="<?php echo Route::_('index.php?option=com_jladmin&view=backupProfiles', false); ?>"
        method="post"
        name="adminForm"
        id="adminForm">
    <div id="j-main-container" class="j-main-container">
        <?php
        // Search tools bar
        echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]);
        ?>
        <?php if (empty($this->items)) : ?>
            <div uk-alert>
                <span uk-icon="info" aria-hidden="true"></span>
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php else : ?>
            <div class="uk-overflow-auto">
                <table class="uk-table uk-table-divider uk-table-hover uk-background-default itemList" id="backupProfilesList">
                    <thead>
                    <tr>
                        <th class="uk-table-shrink uk-text-center">
                            <?php echo HTMLHelper::_('grid.checkall'); ?>
                        </th>
                        <th class="uk-width-expand uk-text-nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-medium uk-text-nowrap uk-visible@m">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JAUTHOR', 'authorName', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JDATE', 'a.createdDate', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap uk-visible@m">
                            <?php echo HTMLHelper::_('searchtools.sort', 'COM_JLADMIN_IS_DEFAULT_PROFILE', 'a.isDefault', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap uk-text-center uk-visible@m">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($this->items as $i => $item) :
                        $canEdit = $user->authorise('core.edit', 'com_jladmin');
                        $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checkedOut == $userId || is_null($item->checkedOut);
                        ?>
                        <tr class="row<?php echo $i % 2; ?>">
                            <td class="uk-text-center">
                                <?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb', $item->title); ?>
                            </td>
                            <td class="uk-text-nowrap">
                                <?php if ($item->checkedOut) : ?>
                                    <?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->editorName, $item->checkedOutTime, 'backupProfiles.', $canCheckin); ?>
                                <?php endif; ?>
                                <?php if ($canEdit || $user->id == $item->createdBy) : ?>
                                    <a class="uk-link-text" href="<?php echo Route::_('index.php?option=com_jladmin&task=backupProfile.edit&id=' . $item->id, false); ?>">
                                        <span uk-icon="link"></span>
                                        <?php echo $this->escape($item->title); ?>
                                    </a>
                                <?php else: ?>
                                    <?php echo $this->escape($item->title); ?>
                                <?php endif; ?>
                            </td>
                            <td class="uk-text-truncate uk-text-meta uk-visible@m">
                                <?php echo $this->escape($item->description); ?>
                            </td>
                            <td class="uk-text-nowrap">
                                <?php
                                if ((int)$item->createdBy != 0) : ?>
                                    <a href="<?php echo Route::_('index.php?option=com_users&view=users&filter[search]=id:' . (int)$item->createdBy, false); ?>">
                                        <?php echo $this->escape($item->authorName); ?>
                                    </a>
                                <?php else : ?>
                                    <?php echo Text::_('JNONE'); ?>
                                <?php endif; ?>
                            </td>
                            <td class="uk-text-center uk-text-nowrap">
                                <?php echo HTMLHelper::_('date', $item->createdDate, Text::_('DATE_FORMAT_LC6')); ?>
                            </td>
                            <td class="uk-text-center uk-visible@m">
                                <button
                                        class="tbody-icon"
                                        type="button"<?php echo $item->isDefault ? ' disabled' : ''; ?>
                                        onclick="this.closest('tr').querySelector('.form-check-input').checked = true; Joomla.submitbutton('backupProfile.setDefault')"
                                >
                                    <?php if ($item->isDefault): ?>
                                        <span class="icon-color-featured icon-star" aria-hidden="true"></span>
                                    <?php else: ?>
                                        <span class="icon-unfeatured" aria-hidden="true"></span>
                                    <?php endif; ?>
                                </button>
                            </td>
                            <td class="uk-text-center uk-visible@m">
                                <?php echo (int)$item->id; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
                <?php echo $this->pagination->getListFooter(); ?>
            </div>
        <?php endif; ?>
        <input type="hidden" name="task" value="">
        <input type="hidden" name="boxchecked" value="0">
        <?php echo HTMLHelper::_('form.token'); ?>
    </div>
    <?php echo JLAdminComponent::renderBottomLink(); ?>
</form>
