<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\Component\JLAdmin\Administrator\Extension\JLAdminComponent;
use Joomla\Plugin\System\Joomlab\Helper\FileSystemHelper;
use Joomla\Registry\Registry;

$app       = Factory::getApplication();
$user      = $this->getCurrentUser();
$userId    = $user->id;
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));

HTMLHelper::_('joomlab.framework');
?>

<form
        class="jl-scope"
        action="<?php echo Route::_('index.php?option=com_jladmin&view=backups', false); ?>"
        method="post"
        name="adminForm"
        id="adminForm">
    <div id="j-main-container" class="j-main-container">
        <?php
        // Search tools bar
        echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]);
        ?>
        <?php if (empty($this->items)) : ?>
            <div class="uk-alert">
                <span uk-icon="info" aria-hidden="true"></span>
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php else : ?>
            <div class="uk-overflow-auto">
                <table class="uk-table uk-table-divider uk-table-hover uk-background-default itemList" id="backupsList">
                    <thead>
                    <tr>
                        <th class="uk-table-shrink uk-text-center">
                            <?php echo HTMLHelper::_('grid.checkall'); ?>
                        </th>
                        <th class="uk-width-expand">
                            <?php echo HTMLHelper::_('searchtools.sort', 'COM_JLADMIN_BACKUP_FILE', 'a.backupFile', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap uk-visible@m">
                            <?php echo HTMLHelper::_('searchtools.sort', 'COM_JLADMIN_BACKUP_PROFILE', 'profileTitle', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap uk-visible@m">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JAUTHOR', 'authorName', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JDATE', 'a.createdDate', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap uk-visible@l">
                            <?php echo HTMLHelper::_('searchtools.sort', 'COM_JLADMIN_ENVIRONMENT', 'a.clientId', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap uk-text-center uk-visible@m">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($this->items as $i => $item) : ?>
                        <tr class="row<?php echo $i % 2; ?>">
                            <td class="uk-text-center">
                                <?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb', $item->backupFile); ?>
                            </td>
                            <td>
                                <?php echo $this->escape(explode('__', $item->backupFile, 2)[1]); ?>
                                <div class="uk-text-meta">
                                    <?php

                                    if ($size = FileSystemHelper::getFileSize(JPATH_ADMINISTRATOR . '/components/com_jladmin/backups/' . $item->backupFile, true)) {
                                        echo $size . 'MB';
                                    } else {
                                        echo 'N/A';
                                    }

                                    echo ' | ';

                                    $profileParams = new Registry($item->profileParams ?: '{}');

                                    echo match ($profileParams->get('backupType')) {
                                        'fullSite' => Text::_('COM_JLADMIN_BACKUP_TYPE_FULL'),
                                        'filesSite' => Text::_('COM_JLADMIN_BACKUP_TYPE_FILES'),
                                        'dbSite' => Text::_('COM_JLADMIN_BACKUP_TYPE_SQL'),
                                    };

                                    $downloadUrl = Route::_('index.php?option=com_jladmin&task=backup.download&backupId=' . $item->id . '&' . Session::getFormToken() . '=1',
                                        false);

                                    echo ' | <a class="uk-link-text uk-text-primary" href="' . $downloadUrl . '"><span uk-icon="cloud-download"></span> ' . Text::_('COM_JLADMIN_DOWNLOAD') . '</a>';

                                    ?>

                                </div>
                            </td>
                            <td class="uk-text-nowrap uk-visible@m">
                                <a href="<?php echo Route::_('index.php?option=com_jladmin&view=backupProfiles&filter[search]=id:' . (int)$item->profileId, false); ?>" target="_blank">
                                    <?php echo $this->escape($item->profileTitle); ?>
                                </a>
                            </td>
                            <td class="uk-text-nowrap uk-visible@m">
                                <?php if ($item->createdBy) : ?>
                                    <a href="<?php echo Route::_('index.php?option=com_users&view=users&filter[search]=id:' . (int)$item->createdBy, false); ?>" target="_blank">
                                        <?php echo $this->escape($item->authorName); ?>
                                    </a>
                                <?php else : ?>
                                    <?php echo Text::_('JNONE'); ?>
                                <?php endif; ?>
                            </td>
                            <td class="uk-text-center uk-text-nowrap">
                                <?php echo HTMLHelper::_('date', $item->createdDate, Text::_('DATE_FORMAT_LC6')); ?>
                            </td>
                            <td class="uk-text-center uk-text-nowrap uk-visible@l">
                                <?php echo Text::_('COM_JLADMIN_ENVIRONMENT_' . $item->clientId); ?>
                            </td>
                            <td class="uk-text-center uk-visible@m">
                                <?php echo (int)$item->id; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
                <?php echo $this->pagination->getListFooter(); ?>
            </div>
        <?php endif; ?>
        <input type="hidden" name="task" value="">
        <input type="hidden" name="boxchecked" value="0">
        <?php echo HTMLHelper::_('form.token'); ?>
    </div>
    <?php echo JLAdminComponent::renderBottomLink(); ?>
</form>
