<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Layout\FileLayout;
use Joomla\Filesystem\Path;
use Joomla\Registry\Registry;

class LayoutHelper
{
    public static function render(string $layoutId, mixed $displayData = null, string $basePath = '', mixed $option = null): string
    {
        return static::getFileLayout($layoutId, $basePath, $option)->render($displayData);
    }

    public static function getFileLayout(string $layoutId, string $basePath = '', mixed $option = null): FileLayout
    {
        $option     = new Registry($option ?: []);
        $fileLayout = new FileLayout($layoutId, null, $option);

        if ($basePath && is_dir($basePath)) {
            if ($option->get('basePathReverse')) {
                $templatePaths  = [];
                $componentPaths = [];
                $otherPaths     = [];

                foreach ($fileLayout->getIncludePaths() as $includePath) {
                    $includePath   = Path::clean($includePath);
                    $componentPath = Path::clean(JPATH_BASE . '/components/com_');
                    $templatePath  = Path::clean(JPATH_THEMES . '/');

                    if (str_starts_with($includePath, $templatePath)) {
                        $templatePaths[] = $includePath;
                    } elseif (str_starts_with($includePath, $componentPath)) {
                        $componentPaths[] = $includePath;
                    } else {
                        $otherPaths[] = $includePath;
                    }
                }

                $fileLayout->setIncludePaths(array_unique(array_merge($templatePaths, [$basePath], $componentPaths, $otherPaths)));
            } else {
                $fileLayout->setIncludePaths(array_unique(array_merge([$basePath], $fileLayout->getIncludePaths())));
            }
        }

        return $fileLayout;
    }
}