<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\MVC\View;

defined('_JEXEC') or die;

use Joomla\CMS\Application\ApplicationHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;

use function count;
use function is_null;

class FormView extends HtmlView
{
    /**
     * @var Form
     * @since 1.0.0
     */
    protected $form;

    /**
     * @var object
     * @since 1.0.0
     */
    protected $item;

    /**
     * @var object
     * @since 1.0.0
     */
    protected $state;

    /**
     * @var string
     * @since 1.0.0
     */
    protected $textPrefix;

    public function display($tpl = null)
    {
        $model       = $this->getModel();
        $this->form  = $model->getForm();
        $this->item  = $model->getItem();
        $this->state = $model->getState();

        if (count($errors = $model->getErrors())) {
            throw new GenericDataException(implode(PHP_EOL, $errors), 500);
        }

        $this->addToolbar();
        parent::display($tpl);
    }


    protected function addToolbar()
    {
        if (empty($this->option)) {
            $this->option = ApplicationHelper::getComponentName();
        }

        if (empty($this->textPrefix)) {
            $this->textPrefix = strtoupper($this->option);
        }

        Factory::getApplication()->input->set('hidemainmenu', true);
        $isNew      = ($this->item->id == 0);
        $toolbar    = BackwardCompatibilityHelper::getToolbar();
        $user       = $this->getCurrentUser();
        $viewName   = $this->getName();
        $checkedOut = !(
            $user->authorise('core.manage', 'com_checkin')
            || $this->item->checkedOut == $user->id
            || is_null($this->item->checkedOut)
        );
        
        ToolbarHelper::title(
            Text::_(strtoupper($this->textPrefix) . '_PAGE_' . strtoupper(($checkedOut ? 'VIEW' : ($isNew ? 'ADD' : 'EDIT')) . '_' . $viewName))
        );

        if ($user->authorise('core.create', $this->option)) {
            $toolbar->apply($viewName . '.apply');
            $saveGroup = $toolbar->dropdownButton('save-group');
            $saveGroup->configure(
                function (Toolbar $childBar) use ($viewName) {
                    $childBar->save($viewName . '.save');
                    $childBar->save2new($viewName . '.save2new');

                    if (!empty($this->item->id)) {
                        $childBar->save2copy($viewName . '.save2copy');
                    }
                }
            );
        }

        $toolbar->cancel($viewName . '.cancel', $isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE');
        $this->prepareToolbar($toolbar);
        $toolbar->divider();
        $toolbar->inlinehelp();
    }

    protected function prepareToolbar(Toolbar $toolbar): void {}
}
