<?php
/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\MVC\View;

defined('_JEXEC') or die;

use Joomla\CMS\Application\ApplicationHelper;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Pagination\Pagination;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;
use Joomla\Registry\Registry;
use Symfony\Component\String\Inflector\EnglishInflector;

class ListView extends BaseHtmlView
{
    /**
     * @var Form
     * @since 1.0.0
     */
    public $filterForm;

    /**
     * @var array
     * @since 1.0.0
     */
    public $activeFilters;

    /**
     * @var array
     * @since 1.0.0
     */

    protected $items;

    /**
     * @var Registry
     * @since 1.0.0
     */
    protected $state;

    /**
     * @var Registry
     * @since 1.0.0
     */
    protected Pagination $pagination;

    /**
     * @var string
     * @since 1.0.0
     */
    protected $textPrefix;

    /**
     * @var bool
     * @since 1.0.1
     */
    protected bool $hasState = true;

    public function display($tpl = null): void
    {
        $model               = $this->getModel();
        $this->items         = $model->getItems();
        $this->pagination    = $model->getPagination();
        $this->state         = $model->getState();
        $this->filterForm    = $model->getFilterForm();
        $this->activeFilters = $model->getActiveFilters();

        // Check for errors.
        if (count($errors = $model->getErrors())) {
            throw new GenericDataException(implode(PHP_EOL, $errors), 500);
        }

        $this->addToolbar();
        parent::display($tpl);
    }

    protected function addToolbar(): void
    {
        if (empty($this->option)) {
            $this->option = ApplicationHelper::getComponentName();
        }

        if (empty($this->textPrefix)) {
            $this->textPrefix = strtoupper($this->option);
        }

        // Get the toolbar object instance
        $toolbar  = BackwardCompatibilityHelper::getToolbar();
        $user     = $this->getCurrentUser();
        $viewName = $this->getName();
        ToolbarHelper::title(Text::_(strtoupper($this->textPrefix . '_PAGE_' . $viewName)));
        $canCheckin = $user->authorise('core.admin') || $user->authorise('core.manage', 'com_checkin');

        if ($user->authorise('core.create', $this->option)) {
            $toolbar->addNew((new EnglishInflector())->singularize($viewName)[0] . '.add');
        }

        if ($this->hasState && $user->authorise('core.edit.state', $this->option)) {
            $dropdown = $toolbar->dropdownButton('status-group')
                ->text('JTOOLBAR_CHANGE_STATUS')
                ->toggleSplit(false)
                ->icon('icon-ellipsis-h')
                ->buttonClass('btn btn-action')
                ->listCheck(true);
            $childBar = $dropdown->getChildToolbar();
            $childBar->publish($viewName . '.publish')->listCheck(true);
            $childBar->unpublish($viewName . '.unpublish')->listCheck(true);

            if ($this->state->get('filter.published') != -2) {
                $childBar->trash($viewName . '.trash')->listCheck(true);
            }

            if ($canCheckin) {
                $childBar->checkin($viewName . '.checkin')->listCheck(true);
            }
        }

        if (!$this->hasState || ($this->state->get('filter.published') == -2 && $user->authorise('core.delete', $this->option))) {
            $toolbar->delete($viewName . '.delete')
                ->text($this->hasState ? 'JTOOLBAR_EMPTY_TRASH' : 'JTOOLBAR_DELETE')
                ->message('JGLOBAL_CONFIRM_DELETE')
                ->listCheck(true);
        }

        if (!$this->hasState && $canCheckin) {
            $toolbar->checkin($viewName . '.checkin')->listCheck(true);
        }

        $this->prepareToolbar($toolbar);

        if ($user->authorise('core.admin', $this->option) || $user->authorise('core.options', $this->option)) {
            $toolbar->preferences($this->option);
        }
    }

    protected function prepareToolbar(Toolbar $toolbar): void {}
}