<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Service\HTML;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Plugin\System\Joomlab\Helper\FileSystemHelper;
use Joomla\Registry\Registry;

class Asset
{
    protected static array $loaded = [];

    public function framework($useCore = false): void
    {
        if (!isset(static::$loaded['framework'])) {
            if (Factory::getApplication()->isClient('administrator')) {
                $willLoad = true;
            } else {
                $params   = new Registry(PluginHelper::getPlugin('system', 'joomlab')->params);
                $willLoad = !!$params->get('loadUIkit', '1');
            }

            if ($willLoad) {
                AssetHelper::getWebAssetManager()
                    ->usePreset('joomlab.uikit');
            }

            static::$loaded['framework'] = true;
        }

        if ($useCore === true || is_array($useCore)) {
            $this->core();

            if (is_array($useCore) && !empty($useCore['coreScripts'])) {
                $this->coreScripts();
            }
        }
    }

    public function core(): void
    {
        if (!isset(static::$loaded['core'])) {
            static::$loaded['core'] = true;
            AssetHelper::getWebAssetManager()
                ->usePreset('joomlab.core');
        }
    }

    public function coreScripts()
    {
        if (!isset(static::$loaded['coreScripts'])) {
            static::$loaded['coreScripts'] = true;
            Text::script('JYES');
            Text::script('JNO');
            Text::script('PLG_SYSTEM_JOOMLAB_CLOSE');
            Text::script('PLG_SYSTEM_JOOMLAB_SEARCH');
            Text::script('PLG_SYSTEM_JOOMLAB_SAVE');
            Text::script('PLG_SYSTEM_JOOMLAB_CANCEL');
            Text::script('PLG_SYSTEM_JOOMLAB_OK');
            Text::script('PLG_SYSTEM_JOOMLAB_SELECT_OR_DRAG_TO_UPLOAD');
            Text::script('PLG_SYSTEM_JOOMLAB_UPLOAD');
            Text::script('PLG_SYSTEM_JOOMLAB_FILE_NAME');
            Text::script('PLG_SYSTEM_JOOMLAB_FILE_TYPE');
            Text::script('PLG_SYSTEM_JOOMLAB_FILE_SIZE');
            Text::script('PLG_SYSTEM_JOOMLAB_FILE_REMOVE');
            Text::script('PLG_SYSTEM_JOOMLAB_UPLOAD_MAX_SIZES');

            $uploadMaxSizeValue = FileSystemHelper::getUploadMaxSizes();
            $uploadMaxSizeText  = FileSystemHelper::toMB($uploadMaxSizeValue);
            Factory::getApplication()
                ->getDocument()
                ->addScriptOptions('joomlab', [
                    'uploadMaxSizes' => ['value' => $uploadMaxSizeValue, 'text' => $uploadMaxSizeText . 'MB'],
                ]);
        }
    }

    public function calendar(): void
    {
        if (!isset(static::$loaded['calendar'])) {
            $language = Factory::getApplication()->getLanguage()->getTag();
            $i10nPath = JPATH_ROOT . '/media/plg_system_joomlab/js/calendar/i10n';
            $i10nFile = $i10nPath . '/' . $language . '.js';

            if (!is_file($i10nFile)) {
                $parts    = explode('-', $language, 2);
                $i10nFile = $i10nPath . '/' . $parts[0] . '.js';

                if (!is_file($i10nFile) && !empty($parts[1])) {
                    $i10nFile = $i10nPath . '/' . $parts[1] . '.js';
                }
            }

            $wa = AssetHelper::getWebAssetManager();

            if (is_file($i10nFile)) {
                $uri = 'plg_system_joomlab/calendar/i10n/' . basename($i10nFile);
                $wa->registerAndUseScript('joomlab.flatpickr-i10n', $uri, [], [], ['joomlab.flatpickr']);
            }

            $wa->usePreset('joomlab.calendar');
            static::$loaded['calendar'] = true;
        }
    }

    public function tabsState()
    {
        if (!isset(static::$loaded['tabsState'])) {
            static::$loaded['tabsState'] = true;
            AssetHelper::getWebAssetManager()->useScript('joomlab.tabs-state');
        }
    }
}