<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Table;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table as BaseTable;
use Joomla\CMS\User\CurrentUserInterface;
use Joomla\CMS\User\CurrentUserTrait;

class Table extends BaseTable implements CurrentUserInterface
{
    use CurrentUserTrait;

    protected $_supportNullValue = true;

    protected $_jsonEncode = ['params'];

    public function check()
    {
        $user = $this->getCurrentUser();
        $date = Factory::getDate()->toSql();

        if ($this->getId()) {
            // Existing item
            if ($this->hasField('modifiedDate')) {
                $this->modifiedDate = $date;
            }

            if ($this->hasField('modifiedBy')) {
                $this->modifiedBy = $user->id;
            }
        } else {
            if ($this->hasField('createdDate')) {
                $this->createdDate = $date;
            }

            if ($this->hasField('createdBy')) {
                $this->createdBy = $user->id;
            }
        }

        return parent::check();
    }

    protected function setupCommonColumnAlias()
    {
        $this->setColumnAlias('published', 'state');
        $this->setColumnAlias('created', 'createdDate');
        $this->setColumnAlias('created_by', 'createdBy');
        $this->setColumnAlias('checked_out', 'checkedOut');
        $this->setColumnAlias('checked_out_time', 'checkedOutTime');
    }
}
