CREATE TABLE IF NOT EXISTS `#__joomlab_backup_profiles`
(
    `id`             INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `isDefault`      TINYINT      NOT NULL DEFAULT 0,
    `title`          VARCHAR(255) NOT NULL,
    `description`    TEXT,
    `params`         MEDIUMTEXT,
    `createdBy`      INT UNSIGNED NOT NULL DEFAULT '0',
    `createdDate`    DATETIME     NULL     DEFAULT NULL,
    `modifiedBy`     INT UNSIGNED NOT NULL DEFAULT '0',
    `modifiedDate`   DATETIME     NULL     DEFAULT NULL,
    `checkedOut`     INT UNSIGNED NULL     DEFAULT NULL,
    `checkedOutTime` DATETIME     NULL     DEFAULT NULL,
    KEY `idx_createdBy` (`createdBy`),
    KEY `idx_checkedOut` (`checkedOut`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  DEFAULT COLLATE utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__joomlab_backups`
(
    `id`          INT UNSIGNED     NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `backupFile`  VARCHAR(1024)    NOT NULL,
    `profileId`   INT UNSIGNED     NOT NULL,
    `clientId`    TINYINT UNSIGNED NOT NULL DEFAULT '1',
    `createdBy`   INT UNSIGNED     NOT NULL DEFAULT '0',
    `createdDate` DATETIME         NULL     DEFAULT NULL,
    KEY `idx_profileId` (`profileId`),
    KEY `idx_createdBy` (`createdBy`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  DEFAULT COLLATE utf8mb4_unicode_ci;

INSERT INTO `#__joomlab_backup_profiles` (`id`, `isDefault`, `title`, `description`, `params`, `createdBy`, `createdDate`, `modifiedBy`, `modifiedDate`, `checkedOut`, `checkedOutTime`) VALUES (1,1,'Full Site Backup','','{\"backupType\":\"fullSite\",\"backupName\":\"site-[SITE]-[DATE]-[TIME]-[TZ]\",\"excludePaths\":\".idea\\r\\n.git\\r\\n.svn\\r\\nCVS\\r\\n.DS_Store\\r\\n_MACOSX\\r\\n\\/cache\\r\\n\\/tmp\\r\\n\\/administrator\\/cache\\r\\n\\/administrator\\/logs\"}',0,'2025-05-08 08:53:59',0,'2025-07-06 04:44:12',NULL,NULL),(2,0,'SQL only profile','','{\"backupType\":\"dbSite\",\"backupName\":\"site-[SITE]-[DATE]T[TIME]-[TZ]\",\"excludePaths\":\".idea\\r\\n.git\\r\\n.svn\\r\\nCVS\\r\\n.DS_Store\\r\\n_MACOSX\\r\\n\\/administrator\\/cache\\r\\n\\/administrator\\/logs\\r\\n\\/tmp\"}',0,'2025-05-08 09:35:50',0,'2025-07-06 04:43:55',NULL,NULL),(3,0,'Sources only profile','','{\"backupType\":\"filesSite\",\"backupName\":\"site-[SITE]-[DATE]-[TIME]-[TZ]\",\"excludePaths\":\".idea\\r\\n.git\\r\\n.svn\\r\\nCVS\\r\\n.DS_Store\\r\\n_MACOSX\\r\\n\\/administrator\\/cache\\r\\n\\/administrator\\/logs\\r\\n\\/tmp\"}',0,'2025-05-16 03:13:29',0,'2025-07-06 04:43:46',NULL,NULL);