<?php

/**
 * @package     Joomlab
 * @subpackage  com_jladmin
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Helper;

use Joomla\CMS\Component\ComponentHelper as CMSComponentHelper;
use Joomla\CMS\Filter\InputFilter;

defined('_JEXEC') or die;

class ComponentHelper
{
    public static function filterPath($path)
    {
        return InputFilter::getInstance()
            ->clean(trim($path, '/\\'), 'path');
    }

    public static function getConfig($key = null, $default = null)
    {
        $config = CMSComponentHelper::getParams('com_jladmin');
        
        return is_string($key) ? $config->get($key, $default) : $config;
    }
}
