<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Plugin\System\Joomlab\MVC\Model\AdminModel;

class BackupProfileModel extends AdminModel
{
    public function canDelete($record): bool
    {
        if ($record->isDefault) {
            Factory::getApplication()
                ->enqueueMessage(Text::_('COM_JLADMIN_CANT_DELETE_DEFAULT_PROFILE_MSG'), 'warning');

            return false;
        }

        return parent::canDelete($record);
    }

    public function save($data)
    {
        if (($result = parent::save($data))
            && Factory::getApplication()->getInput()->get('task') !== 'save2copy'
            && !empty($data['isDefault'])
        ) {
            $this->setDefault((int)$this->getState($this->getName() . '.id'));
        }

        return $result;
    }

    public function setDefault(int $id): bool
    {
        if ($id < 1) {
            return false;
        }

        $db    = $this->getDatabase();
        $query = $db->getQuery(true)
            ->update($db->quoteName('#__joomlab_backup_profiles'))
            ->set($db->quoteName('isDefault') . ' = 0')
            ->where($db->quoteName('isDefault') . ' = 1');
        $db->setQuery($query)
            ->execute();

        $query->clear()
            ->update($db->quoteName('#__joomlab_backup_profiles'))
            ->set($db->quoteName('isDefault') . ' = 1')
            ->where($db->quoteName('id') . ' = ' . $id);
        $db->setQuery($query)
            ->execute();

        return true;
    }

    protected function prepareTable($table)
    {
        if (Factory::getApplication()->getInput()->get('task') === 'save2copy') {
            $table->isDefault = 0;
        }
    }
}
