<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\ListModel;
use Joomla\Database\ParameterType;

class BackupProfilesModel extends ListModel
{
    protected $filterFormName = 'filter_backup_profiles';

    public function __construct($config = [])
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = [
                'id',
                'a.id',
                'isDefault',
                'a.isDefault',
                'title',
                'a.title',
                'description',
                'a.description',
                'createdBy',
                'a.createdBy',
                'createdDate',
                'a.createdDate',
                'authorName',
            ];
        }

        parent::__construct($config);
    }

    protected function populateState($ordering = 'a.id', $direction = 'asc')
    {
        parent::populateState($ordering, $direction);
    }

    protected function getStoreId($id = '')
    {
        // Compile the store id.
        $id .= ':' . $this->getState('filter.search');

        return parent::getStoreId($id);
    }

    protected function getListQuery()
    {
        $db    = $this->getDatabase();
        $query = $db->getQuery(true);
        $query->select(
            $this->getState(
                'list.select',
                'a.id, a.isDefault, a.title, a.description, a.createdBy, a.createdDate, a.checkedOut, a.checkedOutTime'
            )
        )
            ->select('u1.name AS authorName, u2.name AS editorName')
            ->from($db->quoteName('#__joomlab_backup_profiles', 'a'))
            ->join('LEFT', $db->quoteName('#__users', 'u1'), 'u1.id = a.createdBy')
            ->join('LEFT', $db->quoteName('#__users', 'u2'), 'u2.id = a.checkedOut');

        // Filter by search in title.
        $search = $this->getState('filter.search');

        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $search = (int)substr($search, 3);
                $query->where($db->quoteName('a.id') . ' = :search')
                    ->bind(':search', $search, ParameterType::INTEGER);
            } elseif (stripos($search, 'author:') === 0) {
                $search = '%' . substr($search, 7) . '%';
                $query->where($db->quoteName('u1.name') . ' LIKE :search')
                    ->bind(':search', $search);
            } else {
                $search = '%' . trim($search) . '%';
                $query->where('(a.title LIKE :search OR a.description LIKE :search)')
                    ->bind(':search', $search);
            }
        }

        // Add the list ordering clause.
        $orderCol  = $this->state->get('list.ordering', 'a.id');
        $orderDirn = $this->state->get('list.direction', 'asc');
        $query->order($db->escape($orderCol) . ' ' . $db->escape($orderDirn));

        return $query;
    }
}
