<?php

/**
 * @package     Joomlab
 * @subpackage  com_jladmin
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\BaseModel;
use Joomla\Filesystem\Folder;

class SourceModel extends BaseModel
{
    public function getData(string $path = JPATH_ROOT): array
    {
        $folders = Folder::folders($path, '.', false, true, [], ['.svn', '.git']);
        $files   = Folder::files($path, '.', false, true, [], []);

        return [
            'folders' => $folders,
            'files'   => $files,
        ];
    }
}
