<?php

/**
 * @package     Joomlab
 * @subpackage  com_jladmin
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\Trait;

defined('_JEXEC') or die;

use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;
use Joomla\Filesystem\Path;
use RuntimeException;

trait PathTrait
{
    protected function getPath($excludeRoot = false, $inputName = 'path')
    {
        $app   = Factory::getApplication();
        $input = $app->getInput();

        if (!Session::checkToken('request')) {
            throw new RuntimeException(Text::_('JINVALID_TOKEN_NOTICE'));
        }

        if (!$app->getIdentity()->authorise('core.admin', 'com_jladmin')) {
            throw new NotAllowed(Text::_('JERROR_ALERTNOAUTHOR'), 403);
        }

        $path     = base64_decode($input->getBase64($inputName, ''));
        $path     = preg_replace(['/^[^a-z0-9.\-_]/i', '/\/\.+\//'], '', $path);
        $path     = Path::clean($path, '/');
        $fullPath = rtrim(JPATH_ROOT . '/' . $path, '/');

        if (!file_exists($fullPath)) {
            throw new RuntimeException(Text::sprintf('COM_JLADMIN_PATH_NOT_EXISTS_MSG', $path));
        }

        if ($excludeRoot && Path::clean(JPATH_ROOT) === Path::clean($fullPath)) {
            throw new RuntimeException(Text::_('COM_JLADMIN_ROOT_NOT_ACCESSIBLE_MSG'));
        }

        return $path;
    }

    protected function isReadableFile(string $mime): bool
    {
        return str_starts_with($mime, 'text/')
            || in_array(
                $mime, [
                'application/json',
                'application/javascript',
                'application/xml',
                'application/x-httpd-php',
            ]);
    }
}