<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\View\BackupProfiles;

defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\Plugin\System\Joomlab\MVC\View\ListView;

class HtmlView extends ListView
{
    protected $_name = 'backupProfiles';

    protected bool $hasState = false;

    protected function prepareToolbar(Toolbar $toolbar): void
    {
        $toolbar->linkButton('backupLink', 'COM_JLADMIN_MANAGE_BACKUPS')
            ->setOption('icon', 'fa fa-database')
            ->setOption('url', Route::_('index.php?option=com_jladmin&view=backups', false));
    }

}