<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\View\Backups;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;
use Joomla\Plugin\System\Joomlab\MVC\View\ListView;

class HtmlView extends ListView
{
    protected bool $hasState = false;

    protected function addToolbar(): void
    {
        // Get the toolbar object instance
        $toolbar = BackwardCompatibilityHelper::getToolbar();
        $user    = $this->getCurrentUser();
        ToolbarHelper::title(Text::_('COM_JLADMIN_PAGE_BACKUPS'));
        $this->option = 'com_jladmin';

        if ($user->authorise('core.create', $this->option)) {
            HTMLHelper::_('joomlab.core');
            Text::script('COM_JLADMIN_STARTING_BACKUP_MSG');
            Text::script('COM_JLADMIN_BACKUP_DONE_MSG');
            Text::script('COM_JLADMIN_RETURN_TO_BACKUP_LIST');
            Text::script('COM_JLADMIN_STARTING_BACKUP_MSG');
            Text::script('COM_JLADMIN_BACKUP_PROFILE_SELECT');
            Text::script('COM_JLADMIN_BACKUP_FOR_PROFILE_ID_MSG');
            Text::script('COM_JLADMIN_BACKUP_NOW');
            $profilesModel = Factory::getApplication()
                ->bootComponent('jladmin')
                ->getMVCFactory()
                ->createModel('backupProfiles', 'Administrator', ['ignore_request' => true]);
            $profilesModel->setState('list.start', 0);
            $profilesModel->setState('list.limit', 0);
            $profilesModel->setState('list.ordering', 'id');
            $profilesModel->setState('list.direction', 'asc');
            $profilesModel->setState('list.select', 'a.id, a.title, a.isDefault');
            $profiles = $profilesModel->getItems();

            $toolbar->basicButton('backupNow', 'COM_JLADMIN_BACKUP_NOW')
                ->setOption('icon', 'fa fa-database');

            $toolbar->basicButton('backupProfile', 'COM_JLADMIN_BACKUP_PROFILE')
                ->setOption('icon', 'fas fa-id-badge');

            $backupUrl        = Route::_('index.php?option=com_jladmin&task=backup.make&format=json&' . Session::getFormToken() . '=1', false);
            $defaultProfileId = 0;

            foreach ($profiles as $profile) {
                if ($profile->isDefault) {
                    $defaultProfileId = (int)$profile->id;
                    break;
                }
            }

            $this->getDocument()
                ->addScriptOptions(
                    'com_jladmin',
                    [
                        'defaultProfileId' => $defaultProfileId,
                        'backupUrl'        => $backupUrl,
                        'backupProfiles'   => $profiles,
                    ]
                );
            $wa = AssetHelper::getWebAssetManager();
            $wa->getRegistry()
                ->addRegistryFile('media/com_jladmin/joomla.asset.json');
            $wa->useScript('com_jladmin.backup')
                ->addInlineScript(<<<JS
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('#toolbar-backupNow, #toolbar-backupProfile').forEach(toolbar => {
        const isProfile = toolbar.id === 'toolbar-backupProfile';
        toolbar.querySelector('button').addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            if (isProfile) {
                const { backupProfiles } = Joomla.getOptions('com_jladmin');
                const profilesList = document.createElement('select');
                profilesList.className = 'uk-select';
                backupProfiles.forEach(backupProfile => {
                    const option = document.createElement('option');
                    option.value = backupProfile.id;
                    option.innerText = backupProfile.title;
                    
                    if (option.isDefault) {
                        option.selected = true;
                    }
                    
                    profilesList.appendChild(option);
                });
                Joomlab.modal.create(profilesList, {
                    header: Joomla.Text._('COM_JLADMIN_BACKUP_PROFILE_SELECT'),
                    footer: '<button class="jl-modal__prompt-cancel" data-button-close type="button">' + Joomla.Text._('JCANCEL') + '</button>' +
                    '<button class="jl-modal__prompt-ok" type="button">' + Joomla.Text._('COM_JLADMIN_BACKUP_NOW') + '</button>',
                    onShown: modal => {
                        modal.querySelector('.jl-modal__prompt-ok').addEventListener('click', function(e) {
                            e.preventDefault();
                            modal.hide();
                            Joomlab.admin.backup(+profilesList.value);
                        });
                    }
                });
            } else {
                Joomlab.admin.backup();
            }
        });
    });
});
JS
                );
        }

        if ($user->authorise('core.delete', $this->option)) {
            $toolbar->delete('backups.delete')
                ->text('JTOOLBAR_DELETE')
                ->message('JGLOBAL_CONFIRM_DELETE')
                ->listCheck(true);
        }

        if ($user->authorise('core.admin', $this->option) || $user->authorise('core.options', $this->option)) {
            $toolbar->preferences($this->option);
        }
    }
}