<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLAdmin\Administrator\View\Logs;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\ToolbarHelper;

class HtmlView extends BaseHtmlView
{

    public function __construct($config = [])
    {
        if (JLADMIN_PRO) {
            $config['template_path'] = JPATH_PLUGINS . '/jladmin/pro/app/tmpl/logs';
        }

        parent::__construct($config);
    }

    public function display($tpl = null): void
    {
        if (JLADMIN_PRO) {
            $this->addToolbar();
            parent::display($tpl);
        } else {
            echo $this->loadTemplate();
        }
    }

    protected function addToolbar(): void
    {
        $this->option = 'com_jladmin';
        $user         = $this->getCurrentUser();
        $toolbar      = $this->getDocument()->getToolbar();
        ToolbarHelper::title(Text::_('COM_JLADMIN_PAGE_LOGS'));

        $toolbar->link(Text::_('COM_JLADMIN_DASHBOARD'), Route::_('index.php?option=com_jladmin', false))
            ->setOption('icon', 'fa-solid fa-gauge');

        if ($user->authorise('core.admin', $this->option) || $user->authorise('core.options', $this->option)) {
            $toolbar->preferences($this->option);
        }
    }
}