<?php

/**
 * @package     Joomlab
 * @subpackage  com_jladmin
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\JLAdmin\Administrator\Extension\JLAdminComponent;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Plugin\System\Joomlab\Helper\DashboardHelper;

$dashboardHelper = new DashboardHelper();
$dashboardHelper->addItem(
    [
        'text' => Text::_('COM_JLADMIN_MENU_SOURCE'),
        'icon' => 'code',
        'url'  => Route::_('index.php?option=com_jladmin&view=source', false),
    ],
    [
        'text' => Text::_('COM_JLADMIN_MENU_BACKUPS'),
        'icon' => 'database',
        'url'  => Route::_('index.php?option=com_jladmin&view=backups', false),
    ],
    [
        'text' => Text::_('COM_JLADMIN_MENU_BACKUP_PROFILES'),
        'icon' => 'bookmark',
        'url'  => Route::_('index.php?option=com_jladmin&view=backupProfiles', false),
    ],
    [
        'text'     => Text::_('COM_JLADMIN_MENU_LOGS'),
        'icon'     => 'history',
        'url'      => Route::_('index.php?option=com_jladmin&view=logs', false),
        'advanced' => true,
    ],
    [
        'text'     => Text::_('COM_JLADMIN_MENU_BACKUP_CLOUD_STORAGES'),
        'icon'     => 'cloud-upload',
        'url'      => Route::_('index.php?option=com_jladmin&view=backupCloudStorages', false),
        'advanced' => true,
    ],
    [
        'text'     => Text::_('COM_JLADMIN_MENU_MAIL_TRACKER'),
        'icon'     => 'mail',
        'url'      => Route::_('index.php?option=com_jladmin&view=mailTracker', false),
        'advanced' => true,
    ],
    [
        'text'     => Text::_('COM_JLADMIN_MENU_REDIRECTS'),
        'icon'     => 'forward',
        'url'      => Route::_('index.php?option=com_jladmin&view=redirects', false),
        'advanced' => true,
    ],
);

AssetHelper::getWebAssetManager()
    ->useScript('com_jladmin.dashboard');
?>
<div class="jl-scope jl-admin__dashboard">
    <div class="uk-grid-small" uk-grid>
        <div class="uk-width-expand@m">
            <div class="uk-grid-small" uk-grid>
                <?php foreach ($dashboardHelper->getItems() as $item): ?>
                    <div>
                        <div class="uk-card uk-card-<?php echo $item['card'] ?? 'default'; ?> uk-card-small uk-card-body uk-width-small uk-height-small uk-card-hover uk-flex uk-flex-center uk-flex-middle uk-border-rounded">
                            <a class="uk-link-text uk-text-center jl-admin__dashboard__action-link" href="<?php echo $item['url']; ?>">
                                <span uk-icon="icon: <?php echo $item['icon']; ?>; ratio: 1.5"></span>
                                <div class="uk-text-small uk-margin-small-top"><?php echo $item['text']; ?></div>
                                <?php if (!empty($item['advanced']) && !$this->advanced): ?>
                                    <span class="badge bg-danger">PRO</span>
                                <?php endif; ?>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="uk-width-large@m">
            <div class="uk-card uk-card-default uk-card-small">
                <div class="uk-card-header">
                    <h4 class="uk-card-title">
                        <?php echo Text::_('COM_JLADMIN'); ?>
                    </h4>
                </div>
                <div class="uk-card-body">
                    <ul class="uk-list">
                        <li>
                            <strong><?php echo Text::_('JVERSION'); ?></strong>
                            <?php echo $this->advanced ? JLAdminComponent::FULL_VERSION : Text::sprintf('PLG_SYSTEM_JOOMLAB_FREE_VERSION', JLAdminComponent::FULL_VERSION); ?>

                            <?php if (!$this->advanced): ?>
                                <a class="uk-badge uk-text-uppercase uk-text-bold bg-danger" href="https://joomlab.net/joomlab-admin" target="_blank">
                                    <?php echo Text::_('PLG_SYSTEM_JOOMLAB_UPGRADE_NOW'); ?>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <a class="uk-link-text" href="https://joomlab.net/documentation/joomlab-admin" target="_blank">
                                <?php echo Text::_('PLG_SYSTEM_JOOMLAB_DOCUMENTATION'); ?>
                            </a>
                        </li>
                        <li>
                            <a class="uk-link-text" href="https://joomlab.net/license-agreement" target="_blank">
                                <?php echo Text::_('PLG_SYSTEM_JOOMLAB_LICENSE_GPU_V3'); ?>
                            </a>
                        </li>
                        <li>
                            <strong><?php echo Text::_('JAUTHOR'); ?></strong>
                            <a class="uk-link-text" href="https://joomlab.net" target="_blank">
                                Jooml@b Projects
                            </a>
                        </li>
                        <?php if ($this->advanced): ?>
                        <li>
                            <?php echo $dashboardHelper->renderDownloadKeyInput('Joomlab Admin Pro Update Server'); ?>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <?php echo JLAdminComponent::renderBottomLink(); ?>
</div>