<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Helper;

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

class EventSourceHelper
{
    public static function start()
    {
        static $stared = false;

        if ($stared) {
            return;
        }

        $stared = true;

        if (function_exists('ini_set')) {
            ini_set('max_execution_time', 0);
            ini_set('memory_limit', '-1');
        }

        Factory::getApplication()
            ->setHeader('X-Accel-Buffering', 'no')
            ->setHeader('Content-Type', 'text/event-stream')
            ->setHeader('Cache-Control', 'no-cache')
            ->sendHeaders();
    }

    public static function sendProgress(int $percent, array $attributes = [])
    {
        echo 'data:' . json_encode(['percent' => $percent, 'data' => $attributes]), PHP_EOL, PHP_EOL;

        while (ob_get_level() > 0) {
            ob_end_flush();
        }

        flush();
    }
}