<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;

class LanguageHelper
{
    public static function langCodeToFlag(string $langCode): string
    {
        $split       = preg_split('/[-_]/', $langCode, 2);
        $countryCode = strtoupper($split[1] ?? $split[0]);

        // Define the offset for the regional indicator symbols
        $offset = 0x1F1E6;

        // Split the country code into two characters
        $firstChar  = ord($countryCode[0]) - ord('A') + $offset;
        $secondChar = ord($countryCode[1]) - ord('A') + $offset;

        // Convert the Unicode values to UTF-8
        return mb_chr($firstChar, 'UTF-8') . mb_chr($secondChar, 'UTF-8');
    }

    public static function getLanguageCodes(): array
    {
        static $langCodes = null;

        if (null === $langCodes) {
            $langCodes = array_map(function ($language) {
                return $language->lang_code;
            }, static::getLanguages());
        }

        return $langCodes;
    }

    public static function getLanguages(): array
    {
        static $languages = null;

        if (null === $languages) {
            $languagesModel = Factory::getApplication()
                ->bootComponent('com_languages')
                ->getMVCFactory()
                ->createModel('Languages', 'Administrator', ['ignore_request' => true]);
            $languagesModel->setState('filter.published', 1);
            $languagesModel->setState('list.select', 'a.lang_id AS id, a.title, a.title_native, a.lang_code, a.sef');
            $languagesModel->setState('list.start', 0);
            $languagesModel->setState('list.limit', 0);
            $languagesModel->setState('list.ordering', 'a.title');
            $languagesModel->setState('list.direction', 'ASC');
            $languages = $languagesModel->getItems();
        }

        return $languages;
    }

    public static function getDefaultLang(): string
    {
        return ComponentHelper::getParams('com_languages')->get('site', 'en-GB');
    }
}