<?php

/**
 * @package     Joomlab
 * @subpackage  plg_system_joomlab
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\Helper;

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

class StateHelper
{
    protected static StateHelper $instance;

    public function __construct(protected Registry $registry = new Registry()) {}

    public static function getInstance(): StateHelper
    {
        if (!isset(static::$instance)) {
            static::$instance = new StateHelper();
        }

        return static::$instance;
    }

    public function set(string $key, mixed $value): StateHelper
    {
        $this->registry->set($key, $value);

        return $this;
    }

    public function get(string $key, mixed $default = null): mixed
    {
        return $this->registry->get($key, $default);
    }
}