<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\JLForm\Site\Event\AfterSubmitEvent;
use Joomla\Component\JLForm\Site\Event\BeforeShowEvent;
use Joomla\Component\JLForm\Site\Event\BeforeSubmitEvent;

function onJLFormBeforeShow(BeforeShowEvent $event)
{
    $user = Factory::getApplication()->getIdentity();
    if ($user->id) {
        $form   = $event->getForm();
        $return = base64_encode('index.php?option=com_jlform&view=form&id=' . $form->id);
        $event->addResult('<p>Hi ' . $user->name . '!</p><form action="' . Route::_('index.php?option=com_users&task=user.logout',
                false) . '" method="post"><button type="submit" class="btn btn-primary">' . Text::_('JLOGOUT') . '</button>' . HTMLHelper::_('form.token') . '<input type="hidden" name="return" value="' . $return . '"></form>');
    }
}

function onJLFormBeforeSubmit(BeforeSubmitEvent $event)
{
    $app       = Factory::getApplication();
    $validData = $event->getValidData();
    $isLogin   = empty($validData['register']['value']);
    $errors    = [];

    if ($isLogin) {
        $credentials = [
            'username' => $validData['username']['value'],
            'password' => $validData['password']['value'],
        ];

        if (empty($credentials['username']) || !is_string($credentials['username'])) {
            $errors['username'] = 'Invalid username';
        }

        if (empty($credentials['password']) || !is_string($credentials['password'])) {
            $errors['password'] = 'Invalid password';
        }

        if (empty($errors)) {
            if (true !== $app->login($credentials, ['remember' => $validData['remember']['value']])) {
                $errors['__system'] = array_map(
                    function ($msg) {
                        return $msg['message'];
                    }, $app->getMessageQueue(true)
                );
            } else {
                $form = $event->getForm();
                $event->setRedirect(Route::_('index.php?option=com_jlform&view=form&id=' . $form->id, false));
            }
        }
    } else {
        $data = [
            'name'      => $validData['registerName']['value'],
            'username'  => $validData['registerUsername']['value'],
            'email1'    => $validData['registerEmail']['value'],
            'password1' => $validData['registerPassword1']['value'],
        ];

        if (empty($data['name'])) {
            $errors['registerName'] = 'Please enter your name';
        }

        if (empty($data['username'])) {
            $errors['registerUsername'] = 'Please enter your username';
        }

        if (empty($data['email1'])) {
            $errors['registerEmail'] = 'Please enter your email';
        }

        if (empty($data['password1'])) {
            $errors['registerPassword1'] = 'Invalid password';
        }

        if ($data['password1'] !== $validData['registerPassword2']['value']) {
            $errors['registerPassword2'] = 'Password is not matched';
        }

        if (empty($errors)) {
            if (ComponentHelper::getParams('com_users')->get('allowUserRegistration') == 0) {
                $errors['__system'] = ['User registration is not allowed!'];
            } else {
                Form::addFormPath(JPATH_SITE . '/components/com_users/forms');
                $app->getLanguage()->load('com_users');
                $registrationModel = $app->bootComponent('com_users')
                    ->getMVCFactory()
                    ->createModel('Registration', 'Site', ['ignore_request' => true]);
                $return            = $registrationModel->register($data);

                if ($return === false) {
                    $errors['__system'] = [$registrationModel->getError()];
                } elseif ($return === 'adminactivate') {
                    $app->enqueueMessage(Text::_('COM_USERS_REGISTRATION_COMPLETE_VERIFY'));
                    $event->setRedirect(Route::_('index.php?option=com_users&view=registration&layout=complete', false));
                } elseif ($return === 'useractivate') {
                    $app->enqueueMessage(Text::_('COM_USERS_REGISTRATION_COMPLETE_ACTIVATE'));
                    $event->setRedirect(Route::_('index.php?option=com_users&view=registration&layout=complete', false));
                } else {
                    $app->enqueueMessage(Text::_('COM_USERS_REGISTRATION_SAVE_SUCCESS'));
                    $event->setRedirect(Route::_('index.php?option=com_users&view=login', false));
                }
            }
        }
    }

    if ($errors) {
        $event->setErrors(array_merge($event->getErrors(), $errors));
    }
}

function onJLFormAfterSubmit(AfterSubmitEvent $event) {}