<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\Component\JLForm\Administrator\Model\FormsModel;

class FormListField extends ListField
{
    protected $type = 'FormList';

    protected function getOptions()
    {
        /** @var FormsModel $formsModel */
        $app        = Factory::getApplication();
        $formsModel = $app->bootComponent('com_jlform')->getMVCFactory()->createModel('Forms', 'Administrator', ['ignore_request' => true]);
        $formsModel->setState('list.select', 'a.id AS value, a.title AS text');
        $formsModel->setState('filter.published', 1);
        $formsModel->setState('list.ordering', 'a.title');
        $formsModel->setState('list.direction', 'desc');

        if ($app->isClient('site')) {
            $formsModel->setState('filter.submittedBy', $app->getIdentity()->id);
        }

        return array_merge(parent::getOptions(), $formsModel->getItems());
    }
}
