<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\ListModel;
use Joomla\Database\ParameterType;

class SubmissionRepliesModel extends ListModel
{
    public function __construct($config = [])
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = [
                'id',
                'a.id',
                'submissionId',
                'a.submissionId',
                'createdBy',
                'a.createdBy',
                'createdDate',
                'a.createdDate',
                'a.content',
                'content',
            ];
        }

        parent::__construct($config);
    }

    protected function populateState($ordering = 'a.createdDate', $direction = 'desc')
    {
        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        $formId = $this->getUserStateFromRequest($this->context . '.filter.submissionId', 'filter_submissionId', '');
        $this->setState('filter.submissionId', $formId);

        $createdBy = $this->getUserStateFromRequest($this->context . '.filter.createdBy', 'filter_createdBy', '');
        $this->setState('filter.createdBy', $createdBy);

        // List state information.
        parent::populateState($ordering, $direction);
    }

    protected function getStoreId($id = '')
    {
        // Compile the store id.
        $id .= ':' . $this->getState('filter.search');
        $id .= ':' . $this->getState('filter.submissionId');
        $id .= ':' . $this->getState('filter.createdBy');

        return parent::getStoreId($id);
    }

    protected function getListQuery()
    {
        $db    = $this->getDatabase();
        $query = $db->getQuery(true);
        $query->select(
            $this->getState(
                'list.select',
                'a.id, a.submissionId, a.content, a.attachments, a.createdBy, a.createdDate, a.checkedOut, a.checkedOutTime'
            )
        )
            ->select('u1.name AS authorName, u2.name AS editorName')
            ->from($db->quoteName('#__joomlab_form_submission_replies', 'a'))
            ->join('INNER', $db->quoteName('#__joomlab_form_submissions', 'a2'), 'a2.id = a.submissionId')
            ->join('LEFT', $db->quoteName('#__users', 'u1'), 'u1.id = a.createdBy')
            ->join('LEFT', $db->quoteName('#__users', 'u2'), 'u2.id = a.checkedOut');

        // Filter by submissionId state
        $submissionId = $this->getState('filter.submissionId');

        if (is_numeric($submissionId)) {
            $query->where($db->quoteName('a.submissionId') . ' = ' . (int)$submissionId);
        }

        // Filter by author state
        $createdBy = $this->getState('filter.createdBy', '');

        if (is_numeric($createdBy)) {
            $query->where($db->quoteName('a.createdBy') . ' = ' . (int)$createdBy);
        }

        // Filter by search in title.
        $search = $this->getState('filter.search');

        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $search = (int)substr($search, 3);
                $query->where($db->quoteName('a.id') . ' = :search')
                    ->bind(':search', $search, ParameterType::INTEGER);
            } elseif (stripos($search, 'author:') === 0) {
                $search = '%' . substr($search, 7) . '%';
                $query->where($db->quoteName('u1.name') . ' LIKE :search')
                    ->bind(':search', $search);
            } else {
                $search = '%' . trim($search) . '%';
                $query->where($db->quoteName('a.content') . ' LIKE :search')
                    ->bind(':search', $search);
            }
        }

        // Add the list ordering clause.
        $orderCol  = $this->state->get('list.ordering', 'a.id');
        $orderDirn = $this->state->get('list.direction', 'ASC');
        $query->order($db->escape($orderCol) . ' ' . $db->escape($orderDirn));

        return $query;
    }
}
