<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Button\PublishedButton;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Component\JLForm\Administrator\Extension\JLFormComponent;

/** @var WebAssetManager $wa */
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('table.columns')->useScript('multiselect');

$app       = Factory::getApplication();
$user      = $this->getCurrentUser();
$userId    = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));

HTMLHelper::_('joomlab.framework');
?>

<form
        class="jl-scope"
        action="<?php echo Route::_('index.php?option=com_jlform&view=forms', false); ?>"
        method="post"
        name="adminForm"
        id="adminForm">
    <div class="row">
        <div class="col-md-12">
            <div id="j-main-container" class="j-main-container">
                <?php
                // Search tools bar
                echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]);
                ?>
                <?php if (empty($this->items)) : ?>
                    <div class="uk-alert">
                        <span uk-icon="info" aria-hidden="true"></span>
                        <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
                    </div>
                <?php else : ?>
                    <div class="uk-overflow-auto">
                        <table class="uk-table uk-table-divider uk-table-hover uk-background-default itemList" id="formList">
                            <thead>
                            <tr>
                                <th class="uk-table-shrink uk-text-center">
                                    <?php echo HTMLHelper::_('grid.checkall'); ?>
                                </th>
                                <th class="uk-table-shrink uk-text-nowrap uk-text-center">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
                                </th>
                                <th class="uk-table-expand">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
                                </th>
                                <th class="uk-table-shrink uk-text-nowrap uk-visible@m">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JAUTHOR', 'a.createdBy', $listDirn, $listOrder); ?>
                                </th>
                                <th class="uk-table-shrink uk-text-nowrap uk-visible@m">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JDATE', 'a.createdDate', $listDirn, $listOrder); ?>
                                </th>
                                <th class="uk-table-shrink uk-text-nowrap">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'COM_JLFORM_FORM_TOTAL_SUBMISSIONS', 'totalSubmissions', $listDirn, $listOrder); ?>
                                </th>
                                <th class="uk-table-shrink uk-text-nowrap uk-visible@m">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            foreach ($this->items as $i => $item) :
                                $canEdit = $user->authorise('core.edit', 'com_jlform.form.' . $item->id);
                                $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checkedOut == $userId || is_null($item->checkedOut);
                                $canEditOwn = $user->authorise('core.edit.own', 'com_jlform.form.' . $item->id) && $item->createdBy == $userId;
                                $canChange = $user->authorise('core.edit.state', 'com_jlform.form.' . $item->id) && $canCheckin;
                                ?>
                                <tr class="row<?php
                                echo $i % 2; ?>">
                                    <td class="uk-text-center">
                                        <?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb', $item->title); ?>
                                    </td>
                                    <td class="form-status uk-text-center">
                                        <?php
                                        $options = [
                                            'task_prefix' => 'forms.',
                                            'disabled'    => !$canChange,
                                            'id'          => 'state-' . $item->id,
                                        ];

                                        echo (new PublishedButton())->render((int)$item->state, $i, $options);
                                        ?>
                                    </td>
                                    <td class="has-context">
                                        <div class="break-word">
                                            <?php
                                            if ($item->checkedOut) : ?>
                                                <?php
                                                echo HTMLHelper::_('jgrid.checkedout', $i, $item->editorName, $item->checkedOutTime, 'forms.', $canCheckin); ?>
                                            <?php
                                            endif; ?>
                                            <?php
                                            if ($canEdit || $canEditOwn) : ?>
                                                <a href="<?php echo Route::_('index.php?option=com_jlform&task=form.edit&id=' . $item->id, false); ?>"
                                                   title="<?php echo Text::_('JACTION_EDIT'); ?> <?php echo $this->escape($item->title); ?>">
                                                    <?php echo $this->escape($item->title); ?></a>
                                            <?php else : ?>
                                                <span><?php echo $this->escape($item->title); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td class="uk-text-nowrap uk-visible@m">
                                        <?php if ((int)$item->createdBy != 0) : ?>
                                            <a href="<?php echo Route::_('index.php?option=com_users&views=users&filter[search]=id:' . (int)$item->createdBy, false); ?>">
                                                <?php echo $this->escape($item->authorName); ?>
                                            </a>
                                        <?php else : ?>
                                            <?php echo Text::_('JNONE'); ?>
                                        <?php endif; ?>
                                    </td>
                                    <td class="uk-text-nowrap uk-visible@m">
                                        <?php echo HTMLHelper::_('date', $item->createdDate, Text::_('DATE_FORMAT_LC6')); ?>
                                    </td>
                                    <td class="uk-text-center">
                                        <a href="<?php echo Route::_('index.php?option=com_jlform&view=submissions&filter[formId]=' . $item->id, false); ?>"
                                           target="_blank">
                                            <?php echo $item->totalSubmissions; ?>
                                        </a>
                                    </td>
                                    <td class="uk-visible@m">
                                        <?php echo (int)$item->id; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                        <?php echo $this->pagination->getListFooter(); ?>
                    </div>
                <?php endif; ?>
                <input type="hidden" name="task" value="">
                <input type="hidden" name="boxchecked" value="0">
                <?php echo HTMLHelper::_('form.token'); ?>
            </div>
        </div>
    </div>
    <?php echo JLFormComponent::renderBottomLink(); ?>
</form>
