<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\JLForm\Site\Event\PaymentAmountEvent;
use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Plugin\System\Joomlab\Helper\LanguageHelper;
use Joomla\Plugin\System\Joomlab\Helper\LayoutHelper;

HTMLHelper::_('joomlab.framework', true);
$wa = AssetHelper::getWebAssetManager();
$wa->addInlineStyle('#jl-scope-container { z-index: 9999 }');
$app         = Factory::getApplication();
$start       = (int)$app->getUserState('com_jlform.submission.replies.start', 0);
$limit       = (int)ComponentHelper::getParams('com_jlform')->get('submissionRepliesListLimit', 5);
$orderBy     = $app->getUserState('com_jlform.submission.replies.order', 'a.createdDate asc');
$currentLang = $app->getLanguage()->getTag();
$defaultLang = ComponentHelper::getParams('com_languages')->get('site', 'en-GB');
$clientEmails = [];

if ($app->isClient('administrator')) {
    foreach ($this->item->submissionData['data'] ?? [] as $field) {
        $type     = $field['data']['general']['type'] ?? '';
        $format   = $field['data']['options']['format'] ?? '';
        $sendMail = $field['data']['options']['sendEmail'] ?? false;

        if ('text' === strtolower($type)
                && 'email' === strtolower($format)
                && $sendMail
                && !empty(trim($email = $field['value']))
        ) {
            $clientEmails[] = $email;
        }
    }
}

?>

<form class="jl-form__submission-form" action="<?php echo Route::_('index.php?option=com_jlform&layout=edit&id=' . (int)$this->item->id, false); ?>"
      method="post" name="adminForm" id="adminForm">
    <div class="jl-scope">
        <div class="uk-background-default<?php echo $app->isClient('administrator') ? ' uk-padding' : ''; ?>">
            <?php if ($app->isClient('site')): ?>
                <a class="uk-button uk-button-primary" href="<?php echo Route::_('index.php?option=com_jlform&view=submissions', false); ?>">
                    <span uk-icon="arrow-left"></span>
                    <?php echo Text::_('COM_JLFORM_BACK_TO_MY_SUBMISSIONS'); ?>
                </a>
            <?php endif; ?>
            <div class="uk-margin">
                <h5 class="uk-heading-bullet uk-text-uppercase">
                    <?php echo Text::_('COM_JLFORM_SUBMISSION_DETAILS'); ?>
                </h5>
                <table class="uk-table uk-table-small uk-table-responsive uk-table-divider uk-table-middle">
                    <tbody>
                    <tr>
                        <th class="uk-width-medium@s uk-background-muted">
                            <?php echo Text::_('JDATE'); ?>
                        </th>
                        <td>
                            <?php echo HTMLHelper::_('date', $this->item->createdDate, Text::_('DATE_FORMAT_LC6')); ?>
                        </td>
                    </tr>
                    <tr>
                        <th class="uk-width-medium@s uk-background-muted">
                            <?php echo Text::_('COM_JLFORM_SUBMISSION_USER_NAME'); ?>
                        </th>
                        <td>
                            <?php echo $this->item->authorName ?: Text::_('JNONE'); ?>
                        </td>
                    </tr>
                    <tr>
                        <th class="uk-width-medium@s uk-background-muted">
                            <?php echo Text::_('COM_JLFORM_SUBMISSION_USER_TZ'); ?>
                        </th>
                        <td>
                            <?php echo $this->item->userTimeZone; ?>
                        </td>
                    </tr>
                    <tr>
                        <th class="uk-width-medium@s uk-background-muted">
                            <?php echo Text::_('COM_JLFORM_SUBMISSION_USER_LANGUAGE'); ?>
                        </th>
                        <td>
                            <?php echo $this->item->language; ?>
                        </td>
                    </tr>
                    <?php if ($this->item->paymentId):
                        $isPaid = $this->item->paymentStatus === 'Paid';
                        $payOnSubmission = false;

                        if (!$isPaid
                            && $app->isClient('site')
                            && PluginHelper::isEnabled('jlform', $this->item->paymentName)
                        ) {
                            PluginHelper::importPlugin('jlform', $this->item->paymentName);
                            $mvcFactory      = $app->bootComponent('com_jlform')->getMVCFactory();
                            $formModel       = $mvcFactory->createModel('Form', 'Site', ['ignore_request' => true]);
                            $submissionTable = $mvcFactory->createTable('Submission', 'Administrator');
                            $form            = $formModel->getItem($this->item->formId);
                            $submissionTable->load($this->item->id);
                            $amount             = (float)$this->item->paymentAmount;
                            $paymentAmountEvent = new PaymentAmountEvent(
                                'onJLFormPaymentAmount',
                                [
                                    'subject'     => $form,
                                    'submission'  => $submissionTable,
                                    'amount'      => $amount,
                                    'currency'    => $this->item->paymentCurrency,
                                    'paymentName' => $this->item->paymentName,
                                ]
                            );

                            $app->getDispatcher()->dispatch($paymentAmountEvent->getName(), $paymentAmountEvent);

                            if ($paymentAmountEvent->isAllowPayOnSubmissionPage()) {
                                Text::script('COM_JLFORM_PAYMENT_BUTTON_PAY_NOW');
                                Text::script('COM_JLFORM_START_PROCESSING_PAYMENT');
                                LayoutHelper::render(
                                    'form.payment.' . $this->item->paymentName,
                                    ['form' => $form],
                                    JPATH_PLUGINS . '/jlform/' . $this->item->paymentName . '/tmpl',
                                    ['component' => 'com_jlform', 'client' => 0, 'basePathReverse' => true]
                                );

                                $paymentEventName = 'onJLFormPayment' . ucfirst($this->item->paymentName);
                                $doPaymentUrl     = Route::_('index.php?option=com_jlform&task=ajax.doPayment&format=json&' . Session::getFormToken() . '=1&sid=' . $this->item->id, false);
                                $paymentData      = json_encode([
                                    'id'       => (int)$this->item->paymentId,
                                    'name'     => $this->item->paymentName,
                                    'currency' => $this->item->paymentCurrency,
                                    'amount'   => $paymentAmountEvent->getAmount(),
                                ]);

                                $payOnSubmission = true;
                                $wa->usePreset('com_jlform.form-payment')
                                    ->addInlineScript(
                                        trim("
document.addEventListener('onJLFormPaymentDone', ({ detail }) => {
    const alert = Joomlab.modal.alert(detail.message, detail.success ? 'success' : 'error');
    
    if (detail.success) {
        alert.addEventListener('hidden', () => window.location.reload());
    }
    
    detail.done = true;
});

document.addEventListener('DOMContentLoaded', () => {
    const payButton = document.querySelector('.jl-form__submission-form .jl-form__pay-on-submission-button');
    payButton.addEventListener('click', async (e) => {
        e.preventDefault();
        e.stopPropagation();
        const container = document.querySelector('.jl-form__submission-form .jl-form__payment-container'); 
        const detail = {
            doPaymentUrl: '$doPaymentUrl',
            payment: new JLFormPayment(container, $paymentData),
            handlers: [],
        };
        
        payButton.disabled = true;
        container.hidden = false;
        document.dispatchEvent(new CustomEvent('$paymentEventName', { detail }));
        
        if (detail.handlers.length) {
            for (const handler of detail.handlers) {
                if (typeof handler === 'function') {
                    await handler();
                }
            }
        }
        
        
    });
});"
                                        )
                                    );
                            }
                        }
                        ?>
                        <tr>
                            <th class="uk-width-medium@s uk-background-muted">
                                <?php echo Text::_('COM_JLFORM_SUBMISSION_PAYMENT'); ?>
                            </th>
                            <td>
                                <ul class="uk-list uk-list-collapse uk-list-circle uk-text-small">
                                    <li><?php echo Text::sprintf('COM_JLFORM_SUBMISSION_PAYMENT_NAME', strtoupper($this->item->paymentName)); ?></li>
                                    <li><?php echo Text::sprintf('COM_JLFORM_SUBMISSION_PAYMENT_DATE', HTMLHelper::_('date', $this->item->paymentDate, Text::_('DATE_FORMAT_LC6'))); ?></li>
                                    <li><?php echo Text::sprintf('COM_JLFORM_SUBMISSION_PAYMENT_AMOUNT', $this->item->paymentAmount); ?></li>
                                    <li><?php echo Text::sprintf('COM_JLFORM_SUBMISSION_PAYMENT_CURRENCY', $this->item->paymentCurrency); ?></li>
                                    <li>
                                        <?php echo Text::_('COM_JLFORM_SUBMISSION_PAYMENT_STATUS') . ': '; ?>
                                        <div class="uk-display-inline-block uk-text-bold <?php echo $this->item->paymentStatus === 'Paid' ? 'uk-text-success' : 'uk-text-warning' ?>">
                                            <?php if ($isPaid): ?>
                                                <?php echo Text::_('COM_JLFORM_SUBMISSION_PAYMENT_PAID'); ?>
                                            <?php else: ?>
                                                <?php echo Text::_('COM_JLFORM_SUBMISSION_PAYMENT_UNPAID'); ?>
                                            <?php endif; ?>

                                            <?php if ($payOnSubmission): ?>
                                                <button class="jl-form__pay-on-submission-button uk-button uk-button-primary uk-button-small" type="button">
                                                    <?php echo Text::_('COM_JLFORM_PAYMENT_CLICK_TO_PAY'); ?>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </li>
                                </ul>

                                <?php if ($payOnSubmission): ?>
                                    <div class="jl-form__payment-container" hidden></div>
                                <?php endif; ?>
                            </td>
                        </tr>

                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="uk-margin">
                <h5 class="uk-heading-bullet uk-text-uppercase">
                    <?php echo Text::_('COM_JLFORM_SUBMISSION_DATA'); ?>
                </h5>
                <table class="uk-table uk-table-small uk-table-responsive uk-table-divider uk-table-middle" style="table-layout: fixed; word-wrap: break-word">
                    <tbody>
                    <?php
                    $allNameFields = $this->item->submissionData['allNameFields'];
                    $data          = $this->item->submissionData['data'];
                    $hiddenFields  = $this->item->submissionData['hiddenFields'];

                    foreach ($allNameFields as $name):

                        if (in_array($name, $hiddenFields)) {
                            continue;
                        }

                        $field = $data[$name];

                        ?>
                        <tr>
                            <th class="uk-width-medium@s uk-background-muted">
                                <?php echo FormHelper::_($field['labels'] ?? []) ?: $field['label']; ?>
                            </th>
                            <td>
                                <?php

                                switch ($field['data']['general']['type']) {
                                    case 'Calendar':
                                        $arrayValues = is_array($field['value']) ? $field['value'] : [$field['value']];
                                        $dates       = [];
                                        foreach ($arrayValues as $date) {
                                            $date = Factory::getDate($date, new DateTimeZone('UTC'));
                                            $date->setTimezone(new DateTimeZone($this->item->userTimeZone));
                                            $dates[] = $date->format($field['data']['options']['dateFormat'], true);
                                        }

                                        $separator = $field['data']['options']['mode'] === 'range' ? ' <span uk-icon="icon: arrow-right"></span> ' : ', ';
                                        echo implode($separator, $dates);
                                        break;

                                    case 'Upload':
                                        $fileUriBase = Uri::root(true) . '/administrator/components/com_jlform/assets/files/' . $this->item->id;
                                        echo '<ul class="uk-list uk-list-hyphen uk-list-collapse">';

                                        foreach ($field['value'] as $fileHashName => $fileName) {
                                            if ($app->isClient('administrator')) {
                                                echo '<li><a class="uk-text-emphasis uk-text-small" href="' . $fileUriBase . '/' . $fileHashName . '" target="_blank">' . $fileName . '</a></li>';
                                            } else {
                                                echo '<li><span class="uk-text-emphasis uk-text-small">' . $fileName . '</span></li>';
                                            }
                                        }

                                        echo '</ul>';
                                        break;

                                    case 'Color':
                                        echo '<div style="width: 30px; height: 30px; border: 1px solid #f8f8f8; background-color: #' . $data['value'] . '"></div>';
                                        break;

                                    case 'Switcher':
                                        $lblYes = trim($field['data']['options']['lblYes'][$currentLang] ?? $field['data']['options']['lblYes'][$defaultLang] ?? '') ?: Text::_('JYES');
                                        $lblNo  = trim($field['data']['options']['lblNo'][$currentLang] ?? $field['data']['options']['lblNo'][$defaultLang] ?? '') ?: Text::_('JNO');
                                        echo ($field['value'] ?? false) ? $lblYes : $lblNo;
                                        break;

                                    case 'Country':
                                        echo LanguageHelper::langCodeToFlag($field['value']) . ' ' . $field['value'];
                                        break;

                                    default:
                                        echo is_array($field['value']) ? '<ul><li>' . implode('</li><li>', $field['value']) . '</li></ul>' : $field['value'];
                                        break;
                                }

                                ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <hr class="uk-divider-small">
            <div id="jl-form__submission--replies-container">
                <div class="uk-flex uk-flex-wrap">
                    <div class="uk-width-expand">
                        <h5 class="uk-heading-bullet uk-text-uppercase">
                            <?php echo Text::_('COM_JLFORM_SUBMISSION_REPLIES'); ?>
                        </h5>
                    </div>
                    <div class="uk-width-auto uk-margin-small-left">
                        <select class="uk-select uk-form-small uk-width-small" id="jl-form__submission--reply-order">
                            <option value="a.createdDate asc"<?php echo $orderBy === 'a.createdDate asc' ? ' selected' : ''; ?>>
                                <?php echo Text::_('COM_JLFORM_SUBMISSION_REPLIES_ORDER_OLDEST'); ?>
                            </option>
                            <option value="a.createdDate desc"<?php echo $orderBy === 'a.createdDate desc' ? ' selected' : ''; ?>>
                                <?php echo Text::_('COM_JLFORM_SUBMISSION_REPLIES_ORDER_LATEST'); ?>
                            </option>
                        </select>
                    </div>
                </div>

                <div class="uk-margin uk-comment-list" id="jl-form__submission--replies-list"></div>

                <div class="uk-margin action" id="jl-form__submission--reply-action" uk-margin>
                    <textarea class="uk-textarea jl-form__submission--reply-message" rows="3" cols="25" placeholder="Reply" aria-label="Textarea"></textarea>

                    <?php if ($clientEmails): ?>
                        <h5 class="uk-heading-bullet">
                            <?php echo Text::_('COM_JLFORM_COPY_N_SEND_TO_EMAIL'); ?>
                        </h5>
                        <ul class="uk-list">
                            <?php foreach ($clientEmails as $email): ?>
                                <li>
                                    <label>
                                        <input class="uk-checkbox jl-form__submission--reply-send-email" type="checkbox" value="<?php echo htmlspecialchars($email); ?>"/>
                                        <span><?php echo $email; ?></span>
                                    </label>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                    <div class="uk-flex">
                        <button class="uk-button uk-button-primary jl-form__submission--reply-save" type="button">Save</button>
                        <button class="uk-button uk-button-danger jl-form__submission--reply-cancel" type="button">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" name="task" value="">
    <?php echo HTMLHelper::_('form.token'); ?>
</form>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const sid = <?php echo (int)$this->item->id; ?>;
        const repliesMainContainer = document.getElementById('jl-form__submission--replies-container');
        const repliesListContainer = document.getElementById('jl-form__submission--replies-list');
        const repliesActionContainer = document.getElementById('jl-form__submission--reply-action');
        const content = repliesActionContainer.querySelector('.jl-form__submission--reply-message');
        const orderBox = document.getElementById('jl-form__submission--reply-order');

        // Init pagination
        let start = <?php echo $start; ?>;
        let limit = <?php echo $limit; ?>;

        const getBaseUri = () => '<?php echo Uri::base(true); ?>/index.php?option=com_jlform&format=json&order=' + orderBox.value + '&start=' + start + '&limit=' + limit;

        // Register buffer event
        const registerBufferEvents = () => {
            repliesListContainer.querySelectorAll('.jl-form__submission-reply-edit[data-reply-id]').forEach(btn => {
                btn.addEventListener('click', function (e) {
                    e.preventDefault();
                    content.dataset.replyId = btn.getAttribute('data-reply-id') || '0';
                    content.value = btn
                        .closest('.jl-form__submission-reply-container')
                        .querySelector('.jl-form__submission-reply-content')?.dataset.replyContent || '';
                    content.focus();
                });
            });

            repliesListContainer.querySelectorAll('.jl-form__submission-reply-delete[data-reply-id]').forEach(btn => {
                btn.addEventListener('click', function (e) {
                    e.preventDefault();
                    UIkit.modal.confirm('<?php echo Text::_('COM_JLFORM_SUBMISSION_REPLY_DELETE_CONFIRM_MSG', true); ?>').then(function () {
                        const loader = Joomlab.loader.create(repliesMainContainer).show();
                        const formData = new FormData();
                        formData.set('submissionReplyId', btn.dataset.replyId);
                        formData.set('<?php echo Session::getFormToken() ?>', '1');
                        fetch(`${getBaseUri()}&task=submission.deleteReply&submissionReplyId=${sid}`, {method: 'POST', body: formData})
                            .then(res => res.json())
                            .then(json => {
                                loader.close();
                                if (json.success) {
                                    const itemsCount = repliesListContainer.querySelectorAll('.jl-form__submission-reply-container').length;

                                    if (itemsCount === 1) {
                                        start -= limit;
                                    }

                                    loadReplies();
                                }
                            });
                    }, function () {

                    });
                });
            });

            repliesListContainer.querySelectorAll('.jl-form__submission-reply-content__view-more').forEach(btn => {
                btn.addEventListener('click', function (e) {
                    e.preventDefault();
                    const parent = btn.closest('.jl-form__submission-reply-content[data-reply-content]');

                    if (parent) {
                        UIkit.modal.dialog('<p class="uk-padding-small">' + parent.dataset.replyContent.replace(/\r\n|\n/g, '<br>') + '</p>');
                    }
                });
            });

            repliesListContainer.querySelectorAll('.jl-form__submission-reply__pagination-prev, .jl-form__submission-reply__pagination-next').forEach(btn => {
                btn.addEventListener('click', function (e) {
                    e.preventDefault();
                    const isNext = btn.classList.contains('jl-form__submission-reply__pagination-next');

                    if (isNext) {
                        start += limit;
                    } else {
                        start -= limit;

                        if (start < 0) {
                            start = 0;
                        }
                    }

                    resetEditData();
                    loadReplies();
                });
            });
        };

        const resetEditData = () => {
            content.value = '';
            content.dataset.replyId = '0';
            repliesActionContainer.querySelectorAll('.jl-form__submission--reply-send-email').forEach(chb => chb.checked = false);
        };

        // Init edit data
        resetEditData();

        const loadReplies = () => {
            const loader = Joomlab.loader.create(repliesMainContainer).show();
            fetch(`${getBaseUri()}&task=submission.renderListReplies&submissionId=${sid}`)
                .then(res => res.json())
                .then(json => {
                    loader.close();
                    if (json.success) {
                        repliesListContainer.innerHTML = json.data;
                        registerBufferEvents();
                    }
                });
        }

        // Init replies
        loadReplies();

        // Register buttons action
        document.querySelector('.jl-form__submission--reply-save').addEventListener('click', () => {

            if (!(content instanceof HTMLTextAreaElement) || !content.value.trim()) {
                return;
            }

            const formData = new FormData();
            formData.set('submissionId', sid);
            formData.set('submissionReplyId', content.dataset.replyId);
            formData.set('content', content.value.trim());
            repliesActionContainer.querySelectorAll('.jl-form__submission--reply-send-email').forEach(chb => {
                if (chb.checked) {
                    formData.append('sendEmails[]', chb.value);
                }
            });

            formData.set('<?php echo Session::getFormToken() ?>', '1');
            const loader = Joomlab.loader.create(repliesMainContainer).show();
            fetch(`${getBaseUri()}/&task=submission.saveReply`, {
                method: 'POST',
                body: formData,
            })
                .then(res => res.json())
                .then(json => {
                    loader.close();

                    if (json.message) {
                        Joomlab.modal.warning(json.message);
                    }

                    if (json.success) {
                        resetEditData();

                        if (content.dataset.replyId === '0') {
                            const itemsCount = repliesListContainer.querySelectorAll('.jl-form__submission-reply-container').length;

                            if (itemsCount === limit) {
                                start += limit;
                            }
                        }

                        loadReplies();
                    }
                });

        });

        document.querySelector('.jl-form__submission--reply-cancel').addEventListener('click', resetEditData);
        orderBox.addEventListener('change', loadReplies);
    });
</script>