<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

/**
 * @var $displayData array
 * @var $formParams  Registry
 * @var $required    bool
 */

extract($displayData);

?>
<div class="jl-form__field-container uk-margin<?php echo $horizontal ? ' jl-form__field-container-horizontal' : '' ?>">
    <label for="<?php echo $displayData['lblAttrs']['for']; ?>"
           class="uk-form-label<?php echo $horizontal ? ' jl-form__field-container__lbl-horizontal' : '' ?>"<?php echo $hideLabel ? ' hidden' : ''; ?>>
        <?php echo $displayData['label']; ?>
        <?php if ($required) : ?>
            <span>*</span>
        <?php endif; ?>
    </label>

    <div class="uk-form-controls<?php echo $horizontal ? ' jl-form__field-container__ctrl-horizontal' : '' ?>">
        <?php echo $displayData['input']; ?>

        <div class="jl-form__field-container__messages">
            <div class="uk-text-danger jl-form__field__message-feedback" hidden></div>
            <?php if (!empty($displayData['hint'])) : ?>
                <div id="<?php echo $displayData['lblAttrs']['for']; ?>-help-block" class="uk-text-meta">
                    <?php echo $displayData['hint']; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
