<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Date\Date;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Registry\Registry;

/**
 * @var  array    $displayData
 * @var  Registry $options
 * @var  Registry $formParams
 */

extract($displayData);
HTMLHelper::_('joomlab.calendar');

$isBootstrapLayout                            = $formParams->get('formLayout', 'bootstrap') === 'bootstrap';
$ctrlClass                                    = $isBootstrapLayout ? 'form-control' : 'uk-input';
$ctrlSmallClass                               = $isBootstrapLayout ? 'form-control-sm' : 'uk-form-small';
$ctrlLargeClass                               = $isBootstrapLayout ? 'form-control-lg' : 'uk-form-large';
$displayData['ctrlAttrs']['class']            .= $ctrlClass . ($formParams->get('controlSize') === 'small' ? ' ' . $ctrlSmallClass : ($formParams->get('controlSize') === 'large' ? ' ' . $ctrlLargeClass : ''));
$displayData['ctrlAttrs']['data-jl-calendar'] = json_encode([
    'dateFormat' => $options->get('dateFormat', 'Y-m-d H:i'),
    'time24'     => $options->get('format24h', true),
]);

if ($value = $displayData['value'] ?? '') {
    try {
        $date  = Date::getInstance($value);
        $value = $date->format('Y-m-d H:i');
    } catch (Throwable $e) {
        $value = '';
    }
}

?>

<input type="text" name="<?php echo htmlspecialchars($name); ?>" value="<?php echo htmlspecialchars($value); ?>"
    <?php echo FormHelper::buildAttributes($displayData['ctrlAttrs']); ?>/>