<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Registry\Registry;

/**
 * @var  $displayData array
 * @var  $options     Registry
 * @var  $formParams  Registry
 */

extract($displayData);
$isBootstrapLayout = $formParams->get('formLayout', 'bootstrap') === 'bootstrap';
$ctrlClass         = $isBootstrapLayout ? 'form-control form-control-color' : 'uk-input';

?>
<div>
    <input
            type="color"
            name="<?php echo $displayData['name']; ?>"
            value="<?php echo $displayData['value'] ?? ''; ?>"
        <?php echo FormHelper::buildAttributes($displayData['ctrlAttrs']); ?>/>
</div>