<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Registry\Registry;

/**
 * @var  $displayData array
 * @var  $options     Registry
 * @var  $formParams  Registry
 */

extract($displayData);

$isBootstrapLayout = $formParams->get('formLayout', 'bootstrap') === 'bootstrap';
$id                = $displayData['ctrlAttrs']['id'];
$cols              = $options->get('cols', 1);
$value             = $displayData['value'] ?? null;

if ($value && !is_array($value)) {
    $value = [$value];
}

?>

<?php if ($isBootstrapLayout) : ?>
    <div class="jl-form__field--Check-<?php echo $cols; ?>">
        <?php foreach ($options->get('items') as $i => $item) :
            $displayData['ctrlAttrs']['id'] = $id . $i;
            $checked = $value ? in_array($item['value'], $value) : $item['isDefault'];
            ?>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="<?php echo htmlspecialchars($name); ?>"
                       value="<?php echo htmlspecialchars($item['value']); ?>"
                    <?php echo FormHelper::buildAttributes($displayData['ctrlAttrs']); ?>
                    <?php echo $checked ? ' checked' : ''; ?>>
                <label class="form-check-label" for="<?php echo $displayData['ctrlAttrs']['id'] ?>">
                    <?php echo $item['text']; ?>
                </label>
            </div>
        <?php endforeach; ?>
    </div>
<?php else : ?>
    <div class="uk-margin jl-form__field--Radio-<?php echo $cols; ?>">
        <?php foreach ($options->get('items') as $i => $item) :
            $displayData['ctrlAttrs']['id'] = $id . $i;
            $checked = $value ? in_array($item['value'], $value) : $item['isDefault'];
            ?>
            <div>
                <input class="uk-radio" type="radio" name="<?php echo htmlspecialchars($name); ?>"
                       value="<?php echo htmlspecialchars($item['value']); ?>"
                    <?php echo FormHelper::buildAttributes($displayData['ctrlAttrs']); ?>
                    <?php echo $checked ? ' checked' : ''; ?>/>
                <label for="<?php echo $displayData['ctrlAttrs']['id'] ?>">
                    <?php echo $item['text']; ?>
                </label>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
