<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Response\JsonResponse;
use Joomla\CMS\Session\Session;
use Joomla\Component\JLForm\Site\Event\PaymentEvent;
use Joomla\Component\JLForm\Site\Traits\HandleFormTrait;

class AjaxController extends BaseController
{
    use HandleFormTrait;

    public function doPayment()
    {
        if (!Session::checkToken('request')) {
            echo new JsonResponse(null, Text::_('JINVALID_TOKEN_NOTICE'), true);
            $this->app->close();
        }

        $submissionId    = $this->input->getUint('sid');
        $paymentTable    = $this->factory->createTable('SubmissionPayment', 'Administrator');
        $submissionModel = $this->factory->createModel('Submission', 'Administrator', ['ignore_request' => true]);
        $formModel       = $this->factory->createModel('Form', 'Site', ['ignore_request' => true]);

        if ($submissionId > 0
            && ($submission = $submissionModel->getItem($submissionId))
            && $submission->paymentId
            && $paymentTable->load($submission->paymentId)
            && ($form = $formModel->getItem($paymentTable->formId))
            && PluginHelper::isEnabled('jlform', $paymentTable->name)
            && ($paymentPlugin = $this->app->bootPlugin($paymentTable->name, 'jlform'))
        ) {
            $paymentEvent = new PaymentEvent('onJLFormPayment', ['subject' => $form, 'payment' => $paymentTable, 'submission' => $submission]);
            call_user_func_array([$paymentPlugin, 'onJLFormPayment'], [$paymentEvent]);
        }

        $this->app->close();
    }
}
