<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Event;

defined('_JEXEC') or die;

use Joomla\CMS\Event\Result\ResultAware;
use Joomla\CMS\Event\Result\ResultAwareInterface;
use Joomla\CMS\Event\Result\ResultTypeMixedAware;
use Joomla\Event\Event;

abstract class FormEvent extends Event implements ResultAwareInterface
{
    use ResultTypeMixedAware;
    use ResultAware;

    public const BEFORE_SHOW   = 'onJLFormBeforeShow';
    public const BEFORE_SUBMIT = 'onJLFormBeforeSubmit';
    public const AFTER_SUBMIT  = 'onJLFormAfterSubmit';

    public function getResult(): array
    {
        return $this->getArgument('result', []);
    }

    public function getForm(): object
    {
        return $this->getArgument('subject');
    }

}
