<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Helper\FieldValidator;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\Component\JLForm\Site\Helper\FieldValidator;

class ColorField extends FieldValidator
{
    protected ?string $dataType = 'string';

    protected function doValidate(&$value)
    {
        if ($value[0] !== '#') {
            $this->addError(Text::_('COM_JLFORM_ERR_FIELD_COLOR_TYPE_MSG'));

            return false;
        }

        // Remove the leading # if present to validate the numeric part
        $value = ltrim($value, '#');

        // The value must be 6 or 3 characters long
        if (!((strlen($value) == 6 || strlen($value) == 3) && ctype_xdigit($value))) {
            $this->addError(Text::_('COM_JLFORM_ERR_FIELD_COLOR_TYPE_MSG'));

            return false;
        }
    }
}
