<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Helper\FieldValidator;

defined('_JEXEC') or die;

use DateTime;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Component\JLForm\Site\Helper\FieldValidator;

class TimeField extends FieldValidator
{
    protected ?string $dataType = 'string';

    protected function doValidate(&$value)
    {
        $date = Factory::getDate()->format('Y-m-d') . ' ' . $value;

        if (!DateTime::createFromFormat('Y-m-d H:i', $date)) {
            $this->addError(Text::_('JLIB_FORM_FIELD_INVALID_TIME_INPUT'));
        }
    }
}
