<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Helper;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\ParameterType;

defined('_JEXEC') or die;

class PaymentHelper
{
    public static function addUserToGroups(int $userId, array $userGroups)
    {
        /** @var DatabaseInterface $db */
        $db = Factory::getContainer()->get(DatabaseInterface::class);

        // Clear duplicate user groups if exists
        $query = $db->getQuery(true)
            ->delete($db->quoteName('#__user_usergroup_map'))
            ->where($db->quoteName('user_id') . ' = :userId')
            ->whereIn($db->quoteName('group_id'), $userGroups)
            ->bind(':userId', $userId, ParameterType::INTEGER);
        $db->setQuery($query)
            ->execute();

        // Add current user to the groups
        $query->clear()
            ->insert($db->quoteName('#__user_usergroup_map'))
            ->columns($db->quoteName(['user_id', 'group_id']));
        foreach ($userGroups as $userGroup) {
            $query->values($db->quote($userId) . ', ' . $db->quote($userGroup));
        }

        $db->setQuery($query)
            ->execute();
    }
}