CREATE TABLE IF NOT EXISTS `#__joomlab_forms`
(
    `id`             INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `state`          TINYINT      NOT NULL DEFAULT '1',
    `title`          VARCHAR(255) NOT NULL,
    `description`    TEXT,
    `data`           JSON,
    `params`         LONGTEXT,
    `plugins`        LONGTEXT,
    `createdBy`      INT UNSIGNED NOT NULL DEFAULT '0',
    `createdDate`    DATETIME     NULL     DEFAULT NULL,
    `modifiedBy`     INT UNSIGNED NOT NULL DEFAULT '0',
    `modifiedDate`   DATETIME     NULL     DEFAULT NULL,
    `checkedOut`     INT UNSIGNED NULL     DEFAULT NULL,
    `checkedOutTime` DATETIME     NULL     DEFAULT NULL,
    KEY `idx_state` (`state`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  DEFAULT COLLATE utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__joomlab_form_submissions`
(
    `id`             INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `formId`         INT UNSIGNED NOT NULL,
    `submissionData` JSON,
    `metadata`       JSON,
    `createdBy`      INT UNSIGNED NOT NULL DEFAULT '0',
    `createdDate`    DATETIME     NULL     DEFAULT NULL,
    `language`       CHAR(7)      NOT NULL DEFAULT 'en-GB',
    `userTimeZone`   VARCHAR(191) NOT NULL DEFAULT 'UTC',
    `userIP`         VARCHAR(50)  NOT NULL DEFAULT '',
    `checkedOut`     INT UNSIGNED NULL     DEFAULT NULL,
    `checkedOutTime` DATETIME     NULL     DEFAULT NULL,
    KEY `idx_formId` (`formId`),
    KEY `idx_createdBy` (`createdBy`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  DEFAULT COLLATE utf8mb4_unicode_ci;


CREATE TABLE IF NOT EXISTS `#__joomlab_form_submission_payments`
(
    `id`            INT UNSIGNED                                                   NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `transactionId` VARCHAR(191)                                                   NULL     DEFAULT NULL,
    `submissionId`  INT UNSIGNED                                                   NOT NULL,
    `formId`        INT UNSIGNED                                                   NOT NULL,
    `name`          VARCHAR(191)                                                   NOT NULL,
    `amount`        NUMERIC(20, 4)                                                 NULL     DEFAULT NULL,
    `currency`      VARCHAR(10)                                                    NULL     DEFAULT NULL,
    `status`        ENUM ('Pending', 'Cancelled', 'Deposited', 'Paid', 'Refunded') NOT NULL DEFAULT 'Pending',
    `data`          JSON,
    `createdBy`     INT UNSIGNED                                                   NOT NULL DEFAULT '0',
    `createdDate`   DATETIME                                                       NULL     DEFAULT NULL,
    KEY `idx_submissionId` (`submissionId`),
    KEY `idx_createdBy` (`createdBy`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  DEFAULT COLLATE utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__joomlab_form_submission_payment_activities`
(
    `id`                    INT UNSIGNED                                                   NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `status`                ENUM ('Pending', 'Cancelled', 'Deposited', 'Paid', 'Refunded') NOT NULL DEFAULT 'Pending',
    `submissionPaymentId`   INT UNSIGNED                                                   NOT NULL,
    `submissionPaymentName` VARCHAR(191)                                                   NOT NULL,
    `data`                  JSON,
    `createdBy`             INT UNSIGNED                                                   NOT NULL DEFAULT '0',
    `createdDate`           DATETIME                                                       NULL     DEFAULT NULL,
    KEY `idx_submissionPaymentId` (`submissionPaymentId`),
    KEY `idx_createdBy` (`createdBy`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  DEFAULT COLLATE utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__joomlab_form_submission_replies`
(
    `id`             INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `submissionId`   INT UNSIGNED NOT NULL,
    `content`        TEXT         NOT NULL,
    `attachments`    JSON         NULL     DEFAULT NULL,
    `createdBy`      INT UNSIGNED NOT NULL,
    `createdDate`    DATETIME     NULL     DEFAULT NULL,
    `checkedOut`     INT UNSIGNED NULL     DEFAULT NULL,
    `checkedOutTime` DATETIME     NULL     DEFAULT NULL,
    `modifiedBy`     INT UNSIGNED NOT NULL DEFAULT '0',
    `modifiedDate`   DATETIME     NULL     DEFAULT NULL,
    KEY `idx_formId` (`submissionId`),
    KEY `idx_createdBy` (`createdBy`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  DEFAULT COLLATE utf8mb4_unicode_ci;

# Insert sample data
INSERT INTO `#__joomlab_forms` (`id`, `state`, `title`, `description`, `data`, `params`, `plugins`, `createdBy`,
                                `createdDate`, `modifiedBy`, `modifiedDate`, `checkedOut`, `checkedOutTime`)
VALUES (1, 1, 'Contact form', null, '[
  {
    "rows": [
      [
        {
          "data": [
            {
              "general": {
                "hint": {
                  "en-GB": "Enter your name"
                },
                "name": "name",
                "type": "Text",
                "label": {
                  "en-GB": "Name"
                },
                "showOn": "",
                "message": {},
                "lblAttrs": "",
                "required": true,
                "ctrlAttrs": "",
                "hideLabel": false,
                "inlineLabel": false
              },
              "options": {
                "format": "text",
                "integer": false,
                "maximum": null,
                "minimum": null,
                "pattern": null,
                "freeText": {},
                "maxLength": 50,
                "minLength": null,
                "sendEmail": false,
                "defaultValue": null
              }
            }
          ],
          "size": 6
        },
        {
          "data": [
            {
              "general": {
                "hint": {
                  "en-GB": "Enter your email"
                },
                "name": "email",
                "type": "Text",
                "label": {
                  "en-GB": "Your email"
                },
                "showOn": "",
                "message": {},
                "lblAttrs": "",
                "required": true,
                "ctrlAttrs": "",
                "hideLabel": false,
                "inlineLabel": false
              },
              "options": {
                "format": "email",
                "integer": false,
                "maximum": null,
                "minimum": null,
                "pattern": null,
                "freeText": {},
                "maxLength": null,
                "minLength": null,
                "sendEmail": false,
                "defaultValue": null
              }
            }
          ],
          "size": 6
        }
      ],
      [
        {
          "data": [
            {
              "general": {
                "hint": {
                  "en-GB": "Enter your message"
                },
                "name": "message",
                "type": "TextArea",
                "label": {
                  "en-GB": "Message"
                },
                "showOn": "",
                "message": {},
                "lblAttrs": "",
                "required": true,
                "ctrlAttrs": "",
                "hideLabel": false,
                "inlineLabel": false
              },
              "options": {
                "cols": 25,
                "rows": 3,
                "pattern": null,
                "wysiwyg": false,
                "maxLength": null,
                "minLength": null,
                "defaultValue": null
              }
            }
          ],
          "size": 12
        }
      ]
    ],
    "title": {
      "en-GB": "Main"
    }
  }
]',
        '{"formLayout":"bootstrap","controlSize":"medium","formHorizontal":"0","useRecaptcha":"0","requireUserLogin":"0","finishButtonText":{"en-GB":""},"termsAndConditions":"text","tncArticleId":"","tncText":"<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<\\/p>","enableClientEmail":"0","clientEmailSubject":{"en-GB":"Your submission is created"},"clientEmailBody":{"en-GB":"<p>Hi there,<br \\/><br \\/>You have sent a request into our {website}, the detail of the message is bellow.<br \\/><br \\/>{formData}<\\/p>"},"enableAdminEmail":"0","adminEmails":"","adminEmailSubject":{"en-GB":"You have a submission from your client"},"adminEmailBody":{"en-GB":"<p>Hi admin,<br \\/><br \\/>Someone has submitted on your {website}, the detail of the message is bellow.<br \\/><br \\/>{formData}<\\/p>"},"notifyReplyEmail":"1","customCss":"","customJs":""}',
        '{"useBraintree":"0","braintreePaymentPlugin":"1","braintreeTestMode":"1","braintreeUse3DSecure":"0","braintreeTokenizationKey":"","braintreeMerchantId":"","braintreePublicKey":"","braintreePrivateKey":"","braintreeTestTokenizationKey":"","braintreeTestMerchantId":"","braintreeTestPublicKey":"","braintreeTestPrivateKey":"","braintreeCurrency":"USD","braintreeAmount":"","usePaypal":"0","paypalPaymentPlugin":"1","paypalTestMode":"1","paypalClientId":"","paypalSecretId":"","paypalTestClientId":"","paypalTestSecretId":"","paypalCurrency":"USD","paypalAmount":"","useStripe":"0","stripePaymentPlugin":"1","stripeTestMode":"1","stripePublishableKey":"","stripeSecretKey":"","stripeTestPublishableKey":"","stripeTestSecretKey":"","stripeCurrency":"USD","stripeAmount":""}',
        0, '2025-03-26 15:34:04', 0, null, 0, null),
       (2, 1, 'Login/Register form', null, '[
         {
           "rows": [
             [
               {
                 "data": [
                   {
                     "general": {
                       "hint": {},
                       "name": "username",
                       "type": "Text",
                       "label": {
                         "en-GB": "Username"
                       },
                       "showOn": "register!:1",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "text",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": 50,
                       "minLength": null,
                       "sendEmail": false,
                       "defaultValue": null
                     }
                   },
                   {
                     "general": {
                       "hint": {},
                       "name": "password",
                       "type": "Text",
                       "label": {
                         "en-GB": "Password"
                       },
                       "showOn": "register!:1",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "password",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": null,
                       "minLength": null,
                       "sendEmail": false,
                       "defaultValue": null
                     }
                   },
                   {
                     "general": {
                       "hint": {},
                       "name": "remember",
                       "type": "Switcher",
                       "label": {
                         "en-GB": "Remember"
                       },
                       "showOn": "register!:1",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "lblNo": {},
                       "lblYes": {},
                       "checked": false
                     }
                   },
                   {
                     "general": {
                       "hint": {},
                       "type": "Text",
                       "label": {
                         "en-GB": "Forgot Links"
                       },
                       "showOn": "register!:1",
                       "message": {}
                     },
                     "options": {
                       "format": "freeText",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {
                         "en-GB": "<ul class=\\"list-group\\">\\n<li class=\\"list-group-item\\"><a href=\\"index.php?option=com_users&view=reset\\">Forgot your password?</a></li>\\n<li class=\\"list-group-item\\"><a href=\\"index.php?option=com_users&view=remind\\">Forgot your username?</a></li>\\n</ul>"
                       },
                       "maxLength": null,
                       "minLength": null,
                       "sendEmail": false,
                       "defaultValue": null
                     }
                   },
                   {
                     "general": {
                       "hint": {},
                       "name": "register",
                       "type": "Switcher",
                       "label": {
                         "en-GB": "Don''t have an account?"
                       },
                       "showOn": "",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "lblNo": {
                         "en-GB": "Login"
                       },
                       "lblYes": {
                         "en-GB": "Register"
                       },
                       "checked": false
                     }
                   }
                 ],
                 "size": 12
               }
             ],
             [
               {
                 "data": [
                   {
                     "general": {
                       "hint": {},
                       "name": "registerName",
                       "type": "Text",
                       "label": {
                         "en-GB": "Your name"
                       },
                       "showOn": "register:1",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "text",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": 50,
                       "minLength": null,
                       "sendEmail": false,
                       "defaultValue": null
                     }
                   },
                   {
                     "general": {
                       "hint": {},
                       "name": "registerEmail",
                       "type": "Text",
                       "label": {
                         "en-GB": "Your email"
                       },
                       "showOn": "register:1",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "email",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": null,
                       "minLength": null,
                       "sendEmail": false,
                       "defaultValue": null
                     }
                   },
                   {
                     "general": {
                       "hint": {},
                       "name": "registerUsername",
                       "type": "Text",
                       "label": {
                         "en-GB": "Username"
                       },
                       "showOn": "register:1",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "text",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": 50,
                       "minLength": null,
                       "sendEmail": false,
                       "defaultValue": null
                     }
                   },
                   {
                     "general": {
                       "hint": {},
                       "name": "registerPassword1",
                       "type": "Text",
                       "label": {
                         "en-GB": "Password"
                       },
                       "showOn": "register:1",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "password",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": null,
                       "minLength": null,
                       "sendEmail": false,
                       "defaultValue": null
                     }
                   },
                   {
                     "general": {
                       "hint": {},
                       "name": "registerPassword2",
                       "type": "Text",
                       "label": {
                         "en-GB": "Confirm password"
                       },
                       "showOn": "register:1",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "password",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": null,
                       "minLength": null,
                       "sendEmail": false,
                       "defaultValue": null
                     }
                   }
                 ],
                 "size": 12
               }
             ]
           ],
           "title": {
             "en-GB": "Main"
           }
         }
       ]',
        '{"formLayout":"bootstrap","controlSize":"medium","formHorizontal":"0","useRecaptcha":"0","requireUserLogin":"0","finishButtonText":{"en-GB":"Login","vi-VN":""},"termsAndConditions":"","tncArticleId":"","tncText":"","enableClientEmail":"0","clientEmailSubject":{"en-GB":"Your submission is created","vi-VN":""},"clientEmailBody":{"en-GB":"<p>Hi there,<br \\/><br \\/>You have sent a request into our {website}, the detail of the message is bellow.<br \\/><br \\/>{formData}<\\/p>","vi-VN":""},"enableAdminEmail":"0","adminEmails":"","adminEmailSubject":{"en-GB":"You have a submission from your client","vi-VN":""},"adminEmailBody":{"en-GB":"<p>Hi admin,<br \\/><br \\/>Someone has submitted on your {website}, the detail of the message is bellow.<br \\/><br \\/>{formData}<\\/p>","vi-VN":""},"notifyReplyEmail":"1","customCss":"","customJs":"document.addEventListener(''DOMContentLoaded'', () => {\\r\\n  const form = document.querySelector(''.jl-form-{id}'');\\r\\n  form.querySelector(''input[name=\\"JLForm[register]\\"]'').addEventListener(''input'', function() {\\r\\n    form.querySelector(''.js-form__main-step__action--finish'').innerText = this.checked ? ''Register'' : ''Login'';\\r\\n  });\\r\\n});"}',
        null, 0, '2025-03-26 15:42:21', 0, '2025-03-26 16:43:13', 0, null),
       (3, 1, 'Multi-step form', null, '[
         {
           "rows": [
             [
               {
                 "data": [
                   {
                     "general": {
                       "hint": {},
                       "name": "Name",
                       "type": "Text",
                       "label": {
                         "en-GB": "name"
                       },
                       "showOn": "",
                       "message": {},
                       "lblAttrs": "",
                       "required": true,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "text",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": null,
                       "minLength": null,
                       "sendEmail": false,
                       "defaultValue": null
                     }
                   }
                 ],
                 "size": 6
               },
               {
                 "data": [
                   {
                     "general": {
                       "hint": {},
                       "name": "email",
                       "type": "Text",
                       "label": {
                         "en-GB": "Email"
                       },
                       "showOn": "",
                       "message": {},
                       "lblAttrs": "",
                       "required": true,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "email",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": null,
                       "minLength": null,
                       "sendEmail": true,
                       "defaultValue": null
                     }
                   }
                 ],
                 "size": 6
               }
             ],
             [
               {
                 "data": [
                   {
                     "general": {
                       "hint": {},
                       "name": "dob",
                       "type": "Calendar",
                       "label": {
                         "en-GB": "Birthday"
                       },
                       "showOn": "",
                       "message": {},
                       "lblAttrs": "",
                       "required": true,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "mode": "single",
                       "inline": false,
                       "number": 1,
                       "maxDate": null,
                       "maxYear": null,
                       "minDate": null,
                       "minYear": null,
                       "maxMonth": null,
                       "minMonth": null,
                       "format24h": true,
                       "dateFormat": "Y-m-d H:i",
                       "maxDateFromNow": null,
                       "minDateFromNow": null
                     }
                   }
                 ],
                 "size": 6
               },
               {
                 "data": [
                   {
                     "general": {
                       "hint": {},
                       "name": "address",
                       "type": "Text",
                       "label": {
                         "en-GB": "Address"
                       },
                       "showOn": "",
                       "message": {},
                       "lblAttrs": "",
                       "required": true,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "format": "text",
                       "integer": false,
                       "maximum": null,
                       "minimum": null,
                       "pattern": null,
                       "freeText": {},
                       "maxLength": 100,
                       "minLength": null,
                       "sendEmail": true,
                       "defaultValue": null
                     }
                   }
                 ],
                 "size": 6
               }
             ]
           ],
           "title": {
             "en-GB": "Your info"
           }
         },
         {
           "rows": [
             [
               {
                 "data": [
                   {
                     "general": {
                       "hint": {},
                       "name": "work",
                       "type": "CheckList",
                       "label": {
                         "en-GB": "Positions"
                       },
                       "showOn": "",
                       "message": {},
                       "lblAttrs": "",
                       "required": false,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "cols": 3,
                       "items": [
                         {
                           "en-GB": "val:Software development"
                         },
                         {
                           "en-GB": "val:Office Staff"
                         },
                         {
                           "en-GB": "val:Sales Staff"
                         },
                         {
                           "en-GB": "val:Secretary"
                         },
                         {
                           "en-GB": "val:Accounting"
                         },
                         {
                           "en-GB": "val:Other"
                         }
                       ]
                     }
                   },
                   {
                     "general": {
                       "hint": {},
                       "name": "message",
                       "type": "TextArea",
                       "label": {
                         "en-GB": "Message"
                       },
                       "showOn": "",
                       "message": {},
                       "lblAttrs": "",
                       "required": true,
                       "ctrlAttrs": "",
                       "hideLabel": false,
                       "inlineLabel": false
                     },
                     "options": {
                       "cols": 25,
                       "rows": 3,
                       "pattern": null,
                       "wysiwyg": true,
                       "maxLength": null,
                       "minLength": null,
                       "defaultValue": null
                     }
                   }
                 ],
                 "size": 12
               }
             ]
           ],
           "title": {
             "en-GB": "Your work"
           }
         }
       ]',
        '{"formLayout":"bootstrap","controlSize":"medium","formHorizontal":"0","useRecaptcha":"0","requireUserLogin":"0","finishButtonText":{"en-GB":""},"termsAndConditions":"","tncArticleId":"","tncText":"","enableClientEmail":"0","clientEmailSubject":{"en-GB":"Your submission is created"},"clientEmailBody":{"en-GB":"<p>Hi <strong>there<\\/strong>,<br \\/><br \\/>You have sent a request into our {website}, the detail of the message is bellow.<br \\/><br \\/>{formData}<\\/p>"},"enableAdminEmail":"0","adminEmails":"","adminEmailSubject":{"en-GB":"You have a submission from your client"},"adminEmailBody":{"en-GB":"<p>Hi admin,<br \\/><br \\/>Someone has submitted on your {website}, the detail of the message is bellow.<br \\/><br \\/>{formData}<\\/p>"},"notifyReplyEmail":"1","customCss":"","customJs":""}',
        null, 0, '2025-03-26 15:42:35', 0, null, 0, null);