<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Administrator\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Component\Router\RouterServiceInterface;
use Joomla\CMS\Component\Router\RouterServiceTrait;
use Joomla\CMS\Extension\BootableExtensionInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLRegistryAwareTrait;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Event\Event;
use Psr\Container\ContainerInterface;

final class JLFormComponent extends MVCComponent implements
    BootableExtensionInterface,
    RouterServiceInterface
{
    use RouterServiceTrait;
    use HTMLRegistryAwareTrait;

    public const MAJOR_VERSION = 1;

    public const MINOR_VERSION = 0;

    public const PATCH_VERSION = 5;

    public const FULL_VERSION = '1.0.6';

    public const HASH_VERSION = 'b0019d9bc76b51b9510ca0d022c3a4ab';

    public static function renderBottomLink(): string
    {
        return ComponentHelper::getParams('com_jlform')->get('removeBottomLink')
            ? ''
            : '<p style="text-align: center; font-size: 14px; color: #555">'
            . '   <a href="https://joomlab.net/joomlab-form" target="_blank">Joomlab Form</a><sup>v' . JLFormComponent::FULL_VERSION . '</sup> is Free Software released under the GNU General Public License.<br>'
            . '   If you enjoyed your experience with our product, please take a moment to leave a <a href="https://extensions.joomla.org/extension/contacts-and-feedback/forms/jl-form" target="_blank">review on JED</a>'
            . '</p>';
    }

    public function boot(ContainerInterface $container)
    {
        PluginHelper::importPlugin('jlform');
        Factory::getApplication()
            ->getDispatcher()
            ->dispatch('onJLFormBootComponent', new Event('onJLFormBootComponent'));
    }

}
