<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Database\ParameterType;
use Joomla\Plugin\System\Joomlab\MVC\Model\AdminModel;
use RuntimeException;

class SubmissionModel extends AdminModel
{
    public function getItem($pk = null)
    {
        $pk = (int)($pk ?: $this->getState('submission.id', Factory::getApplication()->input->get('id')));

        if (empty($pk)) {
            throw new RuntimeException(Text::_('COM_JLFORM_ERROR_INVALID_SUBMISSION_ID'), 404);
        }


        $db    = $this->getDatabase();
        $query = $db->getQuery(true);

        $query->select(
            $this->getState(
                'item.select',
                [
                    $db->quoteName('a.id'),
                    $db->quoteName('a.formId'),
                    $db->quoteName('a.submissionData'),
                    $db->quoteName('a.metadata'),
                    $db->quoteName('a.createdBy'),
                    $db->quoteName('a.createdDate'),
                    $db->quoteName('a.language'),
                    $db->quoteName('a.userTimeZone'),
                ]
            )
        )
            ->from($db->quoteName('#__joomlab_form_submissions', 'a'))
            ->select([
                $db->quoteName('a2.id', 'paymentId'),
                $db->quoteName('a2.transactionId', 'paymentTransactionId'),
                $db->quoteName('a2.name', 'paymentName'),
                $db->quoteName('a2.status', 'paymentStatus'),
                $db->quoteName('a2.amount', 'paymentAmount'),
                $db->quoteName('a2.currency', 'paymentCurrency'),
                $db->quoteName('a2.data', 'paymentData'),
                $db->quoteName('a2.createdDate', 'paymentDate'),
            ])
            ->join(
                'LEFT',
                $db->quoteName('#__joomlab_form_submission_payments', 'a2'),
                $db->quoteName('a2.submissionId') . ' = ' . $db->quoteName('a.id')
            )
            ->select($db->quoteName('u.name', 'authorName'))
            ->join(
                'LEFT',
                $db->quoteName('#__users', 'u'),
                $db->quoteName('u.id') . ' = ' . $db->quoteName('a.createdBy')
            )
            ->where(
                [
                    $db->quoteName('a.id') . ' = :pk',
                ]
            )
            ->bind(':pk', $pk, ParameterType::INTEGER);


        $db->setQuery($query);
        $item = $db->loadObject();

        if (empty($item)) {
            throw new RuntimeException(Text::_('COM_JLFORM_ERROR_INVALID_SUBMISSION_ID'), 404);
        }

        $item->submissionData = json_decode($item->submissionData ?: '{}', true);
        $item->metadata       = json_decode($item->metadata ?: '{}', true);

        return $item;
    }
}
