<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Administrator\Table;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseDriver;
use Joomla\Database\ParameterType;
use Joomla\Plugin\System\Joomlab\Table\Table;

class SubmissionPaymentTable extends Table
{
    protected $_jsonEncode = ['data'];

    public function __construct(DatabaseDriver $db)
    {
        parent::__construct('#__joomlab_form_submission_payments', 'id', $db);
    }

    public function savePayment(): bool
    {
        if ($result = parent::store()) {
            $userId = $this->getCurrentUser()->id;
            $date   = Factory::getDate()->toSql();
            $data   = is_string($this->data) ? ($this->data ?: '{}') : json_decode($this->data ?: '{}', true);
            $db     = $this->getDbo();
            $query  = $db->getQuery(true)
                ->insert($db->quoteName('#__joomlab_form_submission_payment_activities'))
                ->columns($db->quoteName(['submissionPaymentId', 'submissionPaymentName', 'status', 'data', 'createdBy', 'createdDate']))
                ->values(':submissionPaymentId, :submissionPaymentName, :status, :data, :createdBy, :createdDate')
                ->bind(':submissionPaymentId', $this->id, ParameterType::INTEGER)
                ->bind(':submissionPaymentName', $this->name)
                ->bind(':status', $this->status)
                ->bind(':data', $data)
                ->bind(':createdBy', $userId, ParameterType::INTEGER)
                ->bind(':createdDate', $date);
            $db->setQuery($query)
                ->execute();
        }

        return $result;
    }
}
