<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Administrator\View\Dashboard;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;

class HtmlView extends BaseHtmlView
{
    protected bool $advanced = false;

    public function display($tpl = null)
    {
        PluginHelper::importPlugin('jlform');

        $this->advanced = PluginHelper::isEnabled('jlform', 'pro');
        $this->addToolbar();
        parent::display($tpl);
    }

    protected function addToolbar()
    {
        $toolbar = BackwardCompatibilityHelper::getToolbar();
        $user    = $this->getCurrentUser();
        $option  = 'com_jlform';
        ToolbarHelper::title(Text::_('COM_JLFORM_DASHBOARD'));

        if ($user->authorise('core.admin', $option) || $user->authorise('core.options', $option)) {
            $toolbar->preferences($option);
        }
    }
}
