<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Administrator\View\Submission;

defined('_JEXEC') or die;

use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;
use Joomla\Plugin\System\Joomlab\MVC\View\ItemView;

class HtmlView extends ItemView
{
    public function display($tpl = null)
    {
        parent::display($tpl);
        $app  = Factory::getApplication();
        $user = $app->getIdentity();

        if ($app->isClient('site') && (!$user->id || $this->item->createdBy != $user->id)) {
            throw new NotAllowed(Text::_('JERROR_ALERTNOAUTHOR'), 403);
        }

    }

    protected function addToolbar()
    {
        $toolbar = BackwardCompatibilityHelper::getToolbar();
        ToolbarHelper::title(Text::_('COM_JLFORM_SUBMISSION_DETAILS'));
        $toolbar->cancel('submission.cancel', 'JTOOLBAR_CLOSE');
    }
}