<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Administrator\View\Submissions;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Component\JLForm\Administrator\Model\SubmissionsModel;
use Joomla\Plugin\System\Joomlab\Helper\BackwardCompatibilityHelper;
use Joomla\Plugin\System\Joomlab\MVC\View\ListView;

class HtmlView extends ListView
{
    public function setModel($model, $default = false)
    {
        $app = Factory::getApplication();

        if ($app->isClient('site')) {
            $userId = $app->getIdentity()->id;

            if (!$userId) {
                $return = base64_encode('index.php?option=com_jlform&view=submissions');
                $app->redirect(Route::_('index.php?option=com_users&view=login&return=' . $return, false));
            }

            if ($model instanceof SubmissionsModel) {
                $model->getState(); // Important! force model populate state
                $model->setState('filter.hasUser', 1);
                $model->setState('filter.createdBy', $userId);
            }
        }

        return parent::setModel($model, $default);
    }

    protected function addToolbar(): void
    {
        // Get the toolbar object instance
        $toolbar = BackwardCompatibilityHelper::getToolbar();
        $user    = $this->getCurrentUser();
        ToolbarHelper::title(Text::_(strtoupper('COM_JLFORM_SUBMISSIONS_PAGE_TITLE')));

        if ($user->authorise('core.delete', 'com_jlform')) {
            $toolbar->delete('submissions.delete')
                ->text('JTOOLBAR_DELETE')
                ->message('JGLOBAL_CONFIRM_DELETE')
                ->listCheck(true);
        }

        if ($user->authorise('core.admin')) {
            $toolbar->checkin('submissions.checkin')->listCheck(true);
        }

        if ($user->authorise('core.admin', 'com_jlform') || $user->authorise('core.options', 'com_jlform')) {
            $toolbar->preferences('com_jlform');
        }
    }
}
