<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\JLForm\Administrator\Extension\JLFormComponent;
use Joomla\Component\JLForm\Administrator\View\Dashboard\HtmlView;
use Joomla\Plugin\System\Joomlab\Helper\DashboardHelper;

/** @var HtmlView $this */

$mailchimp       = PluginHelper::isEnabled('jlform', 'mailchimp');
$mailchimpUrl    = 'https://joomlab.net/joomlab-extensions/mailchimp-for-joomlab-form';
$dashboardHelper = new DashboardHelper();
$dashboardHelper->addItem(
    [
        'text' => Text::_('COM_JLFORM_PAGE_FORMS'),
        'icon' => 'file-text',
        'url'  => Route::_('index.php?option=com_jlform&view=forms', false),
    ],
    [
        'text' => Text::_('COM_JLFORM_SUBMISSIONS_PAGE_TITLE'),
        'icon' => 'comments',
        'url'  => Route::_('index.php?option=com_jlform&view=submissions', false),
    ],
    [
        'text'     => 'Mailchimp audiences',
        'icon'     => 'users',
        'url'      => $mailchimp ? Route::_('index.php?option=com_jlform&view=mc_audiences', false) : $mailchimpUrl,
        'advanced' => $mailchimp ? true : 'Require Mailchimp',
    ],
    [
        'text'     => 'Mailchimp contacts',
        'icon'     => 'mail',
        'url'      => $mailchimp ? Route::_('index.php?option=com_jlform&view=mc_contacts', false) : $mailchimpUrl,
        'advanced' => $mailchimp ? true : 'Require Mailchimp',
    ]
);

?>
<div class="jl-scope js-form__dashboard">
    <div class="uk-grid-small" uk-grid>
        <div class="uk-width-expand@m">
            <div class="uk-grid-small" uk-grid>
                <?php foreach ($dashboardHelper->getItems() as $item): ?>
                    <div>
                        <div class="uk-card uk-card-<?php echo $item['card'] ?? 'default'; ?> uk-card-small uk-card-body uk-width-small uk-height-small uk-card-hover uk-flex uk-flex-center uk-flex-middle uk-border-rounded">
                            <a class="uk-link-text uk-text-center" href="<?php echo $item['url']; ?>"<?php  ?>>
                                <span uk-icon="icon: <?php echo $item['icon']; ?>; ratio: 1.5"></span>
                                <div class="uk-text-small uk-margin-small-top"><?php echo $item['text']; ?></div>
                                <?php if (isset($item['advanced']) && true !== $item['advanced']): ?>
                                    <?php if (is_string($item['advanced'])): ?>
                                        <small class="text-danger">
                                            <?php echo $item['advanced']; ?>
                                        </small>
                                    <?php else: ?>
                                        <span class="badge bg-danger">PRO</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="uk-width-large@m">
            <div class="uk-card uk-card-default uk-card-small">
                <div class="uk-card-header">
                    <h4 class="uk-card-title">
                        <?php echo Text::_('COM_JLFORM'); ?>
                    </h4>
                </div>
                <div class="uk-card-body">
                    <ul class="uk-list">
                        <li>
                            <strong><?php echo Text::_('JVERSION'); ?></strong>
                            <?php echo $this->advanced ? JLFormComponent::FULL_VERSION : Text::sprintf('PLG_SYSTEM_JOOMLAB_FREE_VERSION', JLFormComponent::FULL_VERSION); ?>

                            <?php if (!$this->advanced): ?>
                                <a class="uk-badge uk-text-uppercase uk-text-bold bg-danger" href="https://joomlab.net/joomlab-form" target="_blank">
                                    <?php echo Text::_('PLG_SYSTEM_JOOMLAB_UPGRADE_NOW'); ?>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <a class="uk-link-text" href="https://joomlab.net/documentation/joomlab-form" target="_blank">
                                <?php echo Text::_('PLG_SYSTEM_JOOMLAB_DOCUMENTATION'); ?>
                            </a>
                        </li>
                        <li>
                            <a class="uk-link-text" href="https://joomlab.net/license-agreement" target="_blank">
                                <?php echo Text::_('PLG_SYSTEM_JOOMLAB_LICENSE_GPU_V3'); ?>
                            </a>
                        </li>
                        <li>
                            <strong><?php echo Text::_('JAUTHOR'); ?></strong>
                            <a class="uk-link-text" href="https://joomlab.net" target="_blank">
                                Jooml@b Projects
                            </a>
                        </li>
                        <?php if ($this->advanced): ?>
                        <li>
                            <?php echo $dashboardHelper->renderDownloadKeyInput('Joomlab Form Pro Update Server'); ?>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <?php echo JLFormComponent::renderBottomLink(); ?>
</div>