<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Component\JLForm\Administrator\Extension\JLFormComponent;

$app       = Factory::getApplication();
$user      = $this->getCurrentUser();
$userId    = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
$isAdmin   = $app->isClient('administrator');
$itemId    = $app->getInput()->getUint('Itemid');

if ($isAdmin) {
    /** @var WebAssetManager $wa */
    $wa = $this->getDocument()->getWebAssetManager();
    $wa->useScript('table.columns')->useScript('multiselect');
}

HTMLHelper::_('joomlab.framework');
?>

<form
        class="jl-scope"
        action="<?php echo Route::_('index.php?option=com_jlform&view=submissions', false); ?>"
        method="post"
        name="adminForm"
      id="adminForm">
    <div id="j-main-container" class="j-main-container">
        <?php
        // Search tools bar
        echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]);
        ?>
        <?php if (empty($this->items)) : ?>
            <div class="uk-alert">
                <span uk-icon="info" aria-hidden="true"></span>
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php else : ?>
            <div class="uk-overflow-auto">
                <table class="uk-table uk-table-divider uk-table-hover uk-background-default itemList" id="submissionsList">
                    <thead>
                    <tr>
                        <?php if ($isAdmin): ?>
                            <th class="uk-table-shrink uk-text-center">
                                <?php echo HTMLHelper::_('grid.checkall'); ?>
                            </th>
                        <?php endif; ?>
                        <th class="uk-width-medium uk-text-nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JDATE', 'a.createdDate', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-expand">
                            <?php echo HTMLHelper::_('searchtools.sort', 'COM_JLFORM_FORM_TITLE', 'formTitle', $listDirn, $listOrder); ?>
                        </th>
                        <?php if ($isAdmin): ?>
                            <th class="uk-table-shrink uk-text-nowrap">
                                <?php echo HTMLHelper::_('searchtools.sort', 'JAUTHOR', 'authorName', $listDirn, $listOrder); ?>
                            </th>
                            <th class="uk-text-nowrap uk-text-center uk-visible@m">
                                <?php echo HTMLHelper::_('searchtools.sort', 'COM_JLFORM_SUBMISSION_USER_LANGUAGE', 'a.language', $listDirn, $listOrder); ?>
                            </th>
                        <?php endif; ?>
                        <th class="uk-table-shrink uk-text-nowrap uk-text-center">
                            <?php echo HTMLHelper::_('searchtools.sort', 'COM_JLFORM_FORM_TOTAL_REPLIES', 'totalReplies', $listDirn, $listOrder); ?>
                        </th>
                        <th class="uk-table-shrink uk-text-nowrap uk-text-center uk-visible@m">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($this->items as $i => $item) :
                        $canEditForm = $isAdmin && $user->authorise('core.edit', 'com_jlform.form.' . $item->formId);
                        $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checkedOut == $userId || is_null($item->checkedOut);
                        $canChange = $user->authorise('core.edit.state', 'com_jlform.form.' . $item->formId) && $canCheckin;
                        $editLink = Route::_('index.php?option=com_jlform&view=submission&layout=edit&id=' . $item->id . '&Itemid=' . $itemId, false);
                        ?>
                        <tr class="row<?php echo $i % 2; ?>">
                            <?php if ($isAdmin): ?>
                                <td class="uk-text-center">
                                    <?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb', $item->formTitle); ?>
                                </td>
                            <?php endif; ?>
                            <td class="uk-text-nowrap">
                                <?php if ($item->checkedOut && $isAdmin) : ?>
                                    <?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->editorName, $item->checkedOutTime, 'submissions.', $canCheckin); ?>
                                <?php endif; ?>
                                <?php if ($canEditForm || $user->id == $item->createdBy) : ?>
                                    <a class="uk-link-text" href="<?php echo $editLink; ?>">
                                        <span uk-icon="link"></span>
                                        <?php echo HTMLHelper::_('date', $item->createdDate, Text::_('DATE_FORMAT_LC6')); ?>
                                    </a>
                                <?php else: ?>
                                    <span>
                                <?php echo HTMLHelper::_('date', $item->createdDate, Text::_('DATE_FORMAT_LC6')); ?>
                            </span>
                                <?php endif; ?>
                            </td>
                            <td class="has-context">
                                <div class="break-word">
                                    <?php if ($canEditForm): ?>
                                        <a href="<?php echo Route::_('index.php?option=com_jlform&view=forms&filter[search]=id:' . $item->formId, false); ?>"
                                           title="<?php echo Text::_('JACTION_EDIT'); ?> <?php echo $this->escape($item->formTitle); ?>" target="_blank">
                                            <?php echo $this->escape($item->formTitle); ?></a>
                                    <?php else : ?>
                                        <?php echo $this->escape($item->formTitle); ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <?php if ($isAdmin): ?>
                                <td class="uk-text-nowrap">
                                    <?php
                                    if ((int)$item->createdBy != 0) : ?>
                                        <a href="<?php echo Route::_('index.php?option=com_users&view=users&filter[search]=id:' . (int)$item->createdBy, false); ?>">
                                            <?php echo $this->escape($item->authorName); ?>
                                        </a>
                                    <?php else : ?>
                                        <?php echo Text::_('JNONE'); ?>
                                    <?php endif; ?>
                                </td>
                                <td class="uk-text-center uk-visible@m">
                                    <?php echo $item->language; ?>
                                </td>
                            <?php endif; ?>
                            <td class="uk-text-center">
                                <?php if ($canEditForm || $user->id == $item->createdBy) : ?>
                                    <a href="<?php echo Route::_($editLink, false); ?>" class="uk-badge uk-padding-small">
                                        <?php echo $item->totalReplies; ?>
                                    </a>
                                <?php else: ?>
                                    <span class="uk-badge uk-padding-small">
                                    <?php echo $item->totalReplies; ?>
                                </span>
                                <?php endif; ?>
                            </td>
                            <td class="uk-text-center uk-visible@m">
                                <?php echo (int)$item->id; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
                <?php echo $this->pagination->getListFooter(); ?>
            </div>
        <?php endif; ?>
        <input type="hidden" name="task" value="">
        <input type="hidden" name="boxchecked" value="0">
        <?php echo HTMLHelper::_('form.token'); ?>
    </div>
    <?php echo $isAdmin ? JLFormComponent::renderBottomLink() : ''; ?>
</form>
