<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\Component\JLForm\Site\Helper\RouteHelper;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;

/**
 * @var $displayData               array
 * @var $formBuffers               array
 * @var $eventBuffers              array
 * @var $form                      stdClass
 * @var $finishButtonText          string
 */

extract($displayData);
$formLayout = $form->params->get('formLayout');

if ($formLayout === 'uikit') {
    HTMLHelper::_('joomlab.framework');
}

AssetHelper::getWebAssetManager()->usePreset('com_jlform.form-layout-init');
$app      = Factory::getApplication();
$document = $app->getDocument();
$document->addScriptOptions('com_jlform', [
    'language'       => $app->getLanguage()->getTag(),
    'paymentBaseUrl' => Route::_('index.php?option=com_jlform&task=ajax.doPayment&format=json&' . Session::getFormToken() . '=1&sid=', false),
]);

if ($customCss = trim($form->params->get('customCss', ''))) {
    $document->addStyleDeclaration(str_replace('{id}', $form->id, $customCss));
}

$count             = count($formBuffers);
$stepIndex         = 0;
$isBootstrapLayout = $formLayout === 'bootstrap';
$btnSmallClass     = $isBootstrapLayout ? 'btn-sm' : 'uk-button-small';
$btnLargeClass     = $isBootstrapLayout ? 'btn-lg' : 'uk-button-large';
$actionClass       = ($isBootstrapLayout ? 'btn' : 'uk-button') . ($form->params->get('controlSize') === 'small' ? ' ' . $btnSmallClass : ($form->params->get('controlSize') === 'large' ? ' ' . $btnLargeClass : ''));
Text::script('COM_JLFORM_PAYMENT_BUTTON_PAY_NOW');
Text::script('COM_JLFORM_START_PROCESSING_PAYMENT');

?>

    <div class="jl-scope jl-form__container jl-form-<?php echo $form->id; ?> jl-form__<?php echo $formLayout; ?>"
         data-step-count="<?php echo $count; ?>" data-form-id="<?php echo $form->id; ?>">
        <?php if ($count > 1) : ?>
            <div class="jl-form__step-bar jl-form__step-bar--<?php echo $formLayout; ?>">
                <?php foreach ($formBuffers as $title => $formStep) : ?>
                    <div class="jl-form__step-bar__group<?php echo $stepIndex === 0 ? ' active' : '' ?>"
                         data-step="<?php echo ++$stepIndex; ?>">
                        <div class="jl-form__step-bar__group--num"><?php echo $stepIndex; ?></div>
                        <div class="jl-form__step-bar__group--text"><?php echo $title; ?></div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <div class="jl-form__main<?php echo $count > 1 ? ' jl-form__main-has-steps' : '' ?>">
            <?php
            $stepIndex = 0;

            foreach ($formBuffers as $title => $formStepBuffers) :
                $isFinishStep = $count === ++$stepIndex;
                ?>
                <div class="jl-form__main-step<?php echo $stepIndex === 1 ? ' active' : '' ?>"
                     data-step="<?php echo $stepIndex; ?>">
                    <div class="jl-form__main-step__body">
                        <?php echo implode(PHP_EOL, $formStepBuffers); ?>

                        <?php if ($isFinishStep) : ?>
                            <?php echo implode(PHP_EOL, $eventBuffers); ?>

                            <?php if (!empty($form->termsAndConditions)): ?>
                                <label class="jl-form__lbl-tnc" data-jlform-tnc="<?php echo htmlspecialchars($form->termsAndConditions); ?>">
                                    <input class="<?php echo $isBootstrapLayout ? 'd-inline' : 'uk-checkbox'; ?>" name="JLForm[__termsAndCondition]" type="checkbox" value="1">
                                    <?php echo Text::_('COM_JLFORM_FORM_TERMS_N_CONDITIONS_AGREE'); ?>
                                </label>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <div class="jl-form__main-step__action">
                        <?php if ($isFinishStep) : ?>
                            <?php if ($count > 1) : ?>
                                <button class="jl-form__main-step__action--back <?php echo $actionClass; ?>"
                                        type="button">
                                    <?php echo Text::_('COM_JLFORM_STEP_BACK'); ?>
                                </button>
                            <?php endif; ?>

                            <button class="jl-form__main-step__action--finish <?php echo $actionClass; ?>"
                                    type="button">
                                <?php echo $finishButtonText; ?>
                            </button>
                        <?php else : ?>
                            <?php if ($count > 1) : ?>
                                <?php if ($stepIndex > 1) : ?>
                                    <button class="jl-form__main-step__action--back <?php echo $actionClass; ?>"
                                            type="button">
                                        <?php echo Text::_('COM_JLFORM_STEP_BACK'); ?>
                                    </button>
                                <?php endif; ?>

                                <button class="jl-form__main-step__action--next <?php echo $actionClass; ?>"
                                        type="button">
                                    <?php echo Text::_('COM_JLFORM_STEP_NEXT'); ?>
                                </button>
                            <?php else : ?>
                                <button class="jl-form__main-step__action--finish <?php echo $actionClass; ?>"
                                        type="button">
                                    <?php echo $finishButtonText; ?>
                                </button>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php
            endforeach; ?>
        </div>
        <div class="jl-form__submission-finalise" hidden>
            <div class="jl-form__submission-finalise-header-success">
                <?php echo Text::_('COM_JLFORM_FINALISE_HEADING_SUCCESS'); ?>
                <a class="jl-form__submission-finalise__btn-go-back"
                   href="<?php echo Route::_(RouteHelper::getFormRoute($form->id), false); ?>">
                    <?php echo Text::_('COM_JLFORM_FINALISE_GO_BACK'); ?>
                </a>

                <?php if ($app->getIdentity()->id): ?>
                    <a class="jl-form__submission-finalise__btn-view-details"
                       href="<?php echo Route::_(RouteHelper::getSubmissionsRoute(), false); ?>">
                        <?php echo Text::_('COM_JLFORM_FINALISE_MY_SUBMISSIONS'); ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="jl-form__submission-finalise-body"></div>
        </div>
    </div>
<?php

if ($customJs = trim($form->params->get('customJs', ''))) {
    echo '<script>' . str_replace('{id}', $form->id, $customJs) . '</script>';
}