<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

/**
 * @var $displayData array
 * @var $formParams  Registry
 * @var $required    bool
 */

extract($displayData);

?>
<div class="jl-form__field-container mb-3<?php echo $horizontal ? ' jl-form__field-container-horizontal' : '' ?>">
    <label for="<?php echo $displayData['lblAttrs']['for']; ?>"
           class="<?php echo $horizontal ? 'jl-form__field-container__lbl-horizontal form-label' : 'form-label' ?>"<?php echo $hideLabel ? ' hidden' : ''; ?>>
        <?php echo $displayData['label']; ?>
        <?php if ($required) : ?>
            <span>*</span>
        <?php endif; ?>
    </label>

    <?php if ($horizontal) : ?>
        <?php echo '<div class="jl-form__field-container__ctrl-horizontal">'; ?>
    <?php endif; ?>

    <?php echo $displayData['input']; ?>

    <div class="jl-form__field-container__messages">
        <div class="text-danger jl-form__field__message-feedback" hidden></div>

        <?php if (!empty($displayData['hint'])) : ?>
            <div id="<?php echo $displayData['lblAttrs']['for']; ?>-help-block" class="form-text">
                <?php echo $displayData['hint']; ?>
            </div>
        <?php endif; ?>
    </div>

    <?php if ($horizontal) : ?>
        <?php echo '</div>'; ?>
    <?php endif; ?>
</div>
